/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.admin;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.web.SilverpeasWebResource;
import org.silverpeas.core.webapi.admin.StructureElementEntity;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SpaceEntity
extends StructureElementEntity<SpaceEntity> {
    public static final String TYPE = "space";
    private static final long serialVersionUID = 2872199842421965243L;
    @XmlElement(defaultValue="")
    private URI spacesURI;
    @XmlElement(defaultValue="")
    private URI componentsURI;
    @XmlElement(defaultValue="")
    private URI contentURI;
    @XmlElement(defaultValue="")
    private URI appearanceURI;
    @XmlElement
    private int level;
    @XmlElement
    private boolean isSpaceDisplayedAtFirst;
    @XmlElement(defaultValue="")
    private String favorite = "";

    public static SpaceEntity createFrom(SpaceInstLight space, String language) {
        return new SpaceEntity(space, language);
    }

    @Override
    public SpaceEntity withURI(URI uri) {
        super.withURI(uri);
        this.spacesURI = UriBuilder.fromUri((String)this.getStringBaseURI()).path(this.getId()).path("spaces").build(new Object[0]);
        this.componentsURI = UriBuilder.fromUri((String)this.getStringBaseURI()).path(this.getId()).path("components").build(new Object[0]);
        this.contentURI = UriBuilder.fromUri((String)this.getStringBaseURI()).path(this.getId()).path("content").build(new Object[0]);
        this.appearanceURI = UriBuilder.fromUri((String)this.getStringBaseURI()).path(this.getId()).path("appearance").build(new Object[0]);
        return this;
    }

    public SpaceEntity addUserFavorites(String favorite) {
        this.favorite = favorite;
        return this;
    }

    public int getLevel() {
        return this.level;
    }

    public URI getSpacesURI() {
        return this.spacesURI;
    }

    public URI getComponentsURI() {
        return this.componentsURI;
    }

    public URI getContentURI() {
        return this.contentURI;
    }

    public URI getAppearanceURI() {
        return this.appearanceURI;
    }

    public boolean isSpaceDisplayedAtFirst() {
        return this.isSpaceDisplayedAtFirst;
    }

    protected final String getFavorite() {
        return this.favorite;
    }

    private SpaceEntity(SpaceInstLight space, String language) {
        super(TYPE, String.valueOf(space.getLocalId()), space.getFatherId(), space.getName(language), space.getDescription(), space.getStatus(), space.getOrderNum(), space.isInheritanceBlocked());
        this.level = space.getLevel();
        this.isSpaceDisplayedAtFirst = space.isDisplaySpaceFirst();
    }

    protected SpaceEntity() {
    }

    @Override
    protected String getStringBaseURI() {
        return SilverpeasWebResource.getBasePathBuilder().path("spaces").build(new Object[0]).toString();
    }

    @Override
    protected String getStringParentBaseURI() {
        return this.getStringBaseURI();
    }
}

