/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.component.model.SilverpeasComponent;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.component.model.WAComponent;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.security.authorization.SpaceAccessControl;
import org.silverpeas.core.web.SilverpeasWebResource;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.UserPrivilegeValidation;
import org.silverpeas.core.webapi.admin.AbstractPersonnalEntity;
import org.silverpeas.core.webapi.admin.AbstractTypeEntity;
import org.silverpeas.core.webapi.admin.ComponentEntity;
import org.silverpeas.core.webapi.admin.PersonalComponentEntity;
import org.silverpeas.core.webapi.admin.PersonalToolEntity;
import org.silverpeas.core.webapi.admin.SpaceAppearanceEntity;
import org.silverpeas.core.webapi.admin.SpaceEntity;
import org.silverpeas.core.webapi.admin.delegate.AdminPersonalWebDelegate;
import org.silverpeas.core.webapi.admin.tools.AbstractTool;
import org.silverpeas.core.webapi.look.delegate.LookWebDelegate;

public abstract class AbstractAdminResource
extends RESTWebService {
    @Inject
    protected OrganizationController orgaController;
    @QueryParam(value="admin-access")
    private boolean adminAccess = false;
    private AdminPersonalWebDelegate adminPersonalDelegate;
    @Inject
    private SpaceAccessControl spaceAccessController;
    @Inject
    private ComponentAccessControl componentAccessController;
    private LookWebDelegate lookDelegate;

    protected SpaceInstLight loadSpace(String spaceId) {
        return this.loadSpaces(false, spaceId).findFirst().orElse(null);
    }

    protected Stream<SpaceInstLight> loadSpaces(String ... spaceIds) {
        return this.loadSpaces(true, spaceIds);
    }

    private Stream<SpaceInstLight> loadSpaces(boolean authorizationCheck, String ... spaceIds) {
        Stream stream = !authorizationCheck || this.isValidAdminAccess() ? Stream.of(spaceIds) : this.spaceAccessController.filterAuthorizedByUser(List.of(spaceIds), this.getUser().getId());
        return stream.map(arg_0 -> ((OrganizationController)this.orgaController).getSpaceInstLightById(arg_0)).filter(Objects::nonNull);
    }

    protected ComponentInstLight loadComponent(String componentId) {
        return this.loadComponents(false, componentId).findFirst().orElse(null);
    }

    protected Stream<ComponentInstLight> loadComponents(String ... componentIds) {
        return this.loadComponents(true, componentIds);
    }

    private Stream<ComponentInstLight> loadComponents(boolean authorizationCheck, String ... componentIds) {
        Stream stream = !authorizationCheck || this.isValidAdminAccess() ? Stream.of(componentIds) : this.componentAccessController.filterAuthorizedByUser(List.of(componentIds), this.getUser().getId());
        return stream.map(arg_0 -> ((OrganizationController)this.orgaController).getComponentInstLight(arg_0)).filter(Objects::nonNull);
    }

    protected Stream<ComponentInstLight> filterAuthorizedComponents(Collection<ComponentInstLight> componentInstances) {
        Stream<ComponentInstLight> stream;
        if (this.isValidAdminAccess()) {
            stream = componentInstances.stream();
        } else {
            Map<String, ComponentInstLight> indexed = componentInstances.stream().collect(Collectors.toMap(ComponentInstLight::getId, c -> c));
            stream = this.componentAccessController.filterAuthorizedByUser((Collection)componentInstances.stream().map(ComponentInstLight::getId).collect(Collectors.toList()), this.getUser().getId()).map(indexed::get);
        }
        return stream;
    }

    protected <T, E extends AbstractTypeEntity> Collection<E> asWebEntities(Stream<T> data) {
        return this.asWebEntities(data, false);
    }

    protected <T, E extends AbstractTypeEntity> Collection<E> asWebEntities(Stream<T> data, boolean forceGettingFavorite) {
        return data.map(object -> {
            if (object instanceof SpaceInstLight) {
                return this.asWebEntity((SpaceInstLight)object, forceGettingFavorite);
            }
            if (object instanceof ComponentInstLight) {
                return this.asWebEntity((ComponentInstLight)object);
            }
            return this.asWebEntity(object);
        }).collect(Collectors.toList());
    }

    protected <T, E extends AbstractTypeEntity> Collection<E> asWebPersonalEntities(Collection<T> data) {
        ArrayList<AbstractPersonnalEntity> entities = new ArrayList<AbstractPersonnalEntity>(data.size());
        for (T object : data) {
            if (object instanceof WAComponent) {
                entities.add(this.asWebPersonalEntity((SilverpeasComponent)object));
                continue;
            }
            if (object instanceof ComponentInst) {
                entities.add(this.asWebPersonalEntity((SilverpeasComponentInstance)object));
                continue;
            }
            if (object instanceof AbstractTool) {
                entities.add(this.asWebPersonalEntity((AbstractTool)object));
                continue;
            }
            this.asWebEntity(object);
        }
        return entities;
    }

    protected SpaceEntity asWebEntity(SpaceInstLight space, boolean forceGettingFavorite) {
        this.checkNotFoundStatus(space);
        StringBuilder userFavoriteSpace = new StringBuilder();
        if (this.isUserAuthorizedToAccessLookContext()) {
            userFavoriteSpace.append(this.getLookDelegate().getUserFavorite(space, forceGettingFavorite));
        }
        return SpaceEntity.createFrom(space, this.getUserPreferences().getLanguage()).withURI(SilverpeasWebResource.getBasePathBuilder().path("spaces").path(String.valueOf(space.getLocalId())).build(new Object[0])).addUserFavorites(userFavoriteSpace.toString());
    }

    protected SpaceAppearanceEntity asWebEntity(SpaceInstLight space, String look, String wallpaper, String css) {
        this.checkNotFoundStatus(space);
        return SpaceAppearanceEntity.createFrom(space, look, wallpaper, css).withURI(SilverpeasWebResource.getBasePathBuilder().path("spaces").path(String.valueOf(space.getLocalId())).path("appearance").build(new Object[0]));
    }

    protected ComponentEntity asWebEntity(ComponentInstLight component) {
        this.checkNotFoundStatus(component);
        return (ComponentEntity)ComponentEntity.createFrom(component, this.getUserPreferences().getLanguage()).withURI(SilverpeasWebResource.getBasePathBuilder().path("components").path(component.getId()).build(new Object[0]));
    }

    protected PersonalComponentEntity asWebPersonalEntity(SilverpeasComponent component) {
        this.checkNotFoundStatus(component);
        return (PersonalComponentEntity)PersonalComponentEntity.createFrom(component, this.getAdminPersonalDelegate().getComponentLabel(component), this.getUserPreferences().getLanguage()).withUriBase(this.getUri().getBaseUri());
    }

    protected PersonalComponentEntity asWebPersonalEntity(SilverpeasComponentInstance component) {
        this.checkNotFoundStatus(component);
        return (PersonalComponentEntity)PersonalComponentEntity.createFrom(component).withUriBase(this.getUri().getBaseUri());
    }

    protected PersonalToolEntity asWebPersonalEntity(AbstractTool tool) {
        this.checkNotFoundStatus(tool);
        return (PersonalToolEntity)PersonalToolEntity.createFrom(tool).withUriBase(this.getUri().getBaseUri());
    }

    protected AbstractTypeEntity asWebEntity(Object object) {
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    private void checkNotFoundStatus(Object object) {
        if (object == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    protected AdminPersonalWebDelegate getAdminPersonalDelegate() {
        if (this.adminPersonalDelegate == null) {
            this.adminPersonalDelegate = AdminPersonalWebDelegate.getInstance(this.getUser(), this.getUserPreferences(), this.getLookDelegate());
        }
        return this.adminPersonalDelegate;
    }

    protected void verifyUserAuthorizedToAccessSpace(String spaceId) {
        if (!this.isValidAdminAccess() && !this.spaceAccessController.isUserAuthorized(this.getUser().getId(), (Object)spaceId)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    public void validateUserAuthorization(UserPrivilegeValidation validation) {
        if (!this.isValidAdminAccess()) {
            super.validateUserAuthorization(validation);
        }
    }

    protected void verifyUserAuthorizedToAccessLookContext() {
        if (!this.isUserAuthorizedToAccessLookContext()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    protected boolean isUserAuthorizedToAccessLookContext() {
        if (this.lookDelegate == null) {
            this.lookDelegate = LookWebDelegate.getInstance(this.getUser(), this.getUserPreferences(), this.getHttpServletRequest());
        }
        return this.lookDelegate.getHelper() != null;
    }

    protected LookWebDelegate getLookDelegate() {
        this.verifyUserAuthorizedToAccessLookContext();
        return this.lookDelegate;
    }

    private boolean isValidAdminAccess() {
        return this.adminAccess && this.getUser().isAccessAdmin();
    }
}

