/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.monthcalendar;

import java.util.Calendar;
import java.util.Date;

public class Event {
    private String id = null;
    private String name = null;
    private Date startDate = null;
    private Date endDate = null;
    private String url = null;
    private int priority = 0;
    private String startHour = null;
    private String endHour = null;
    private String place = null;
    private String color = null;
    private String instanceId = null;
    private String tooltip = null;

    public Event(String id, String name, Date sDate, Date eDate, String url, int priority) {
        this.init(id, name, sDate, eDate, url, priority);
    }

    public Event(Event event) {
        this.init(event.getId(), event.getName(), event.getStartDate(), event.getEndDate(), event.getUrl(), event.getPriority());
        this.startHour = event.getStartHour();
        this.endHour = event.getEndHour();
        this.place = event.getPlace();
        this.color = event.getColor();
        this.instanceId = event.getInstanceId();
        this.tooltip = event.getTooltip();
    }

    private void init(String id, String name, Date sDate, Date eDate, String url, int priority) {
        this.id = id;
        this.name = name;
        Calendar cal = Calendar.getInstance();
        cal.setTime(sDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.startDate = cal.getTime();
        if (eDate == null) {
            this.endDate = this.startDate;
        } else {
            cal.setTime(eDate);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.endDate = cal.getTime();
        }
        this.url = url;
        this.priority = priority;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Date getStartDate() {
        return new Date(this.startDate.getTime());
    }

    public void setStartDate(Date date) {
        this.startDate = new Date(date.getTime());
    }

    public Date getEndDate() {
        return new Date(this.endDate.getTime());
    }

    public void setEndDate(Date date) {
        this.endDate = new Date(date.getTime());
    }

    public String getUrl() {
        return this.url;
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean compareTo(Event evt) {
        boolean val = true;
        Date startDateEvt = evt.getStartDate();
        Date endDateEvt = evt.getEndDate();
        int St_StEvt = this.startDate.compareTo(startDateEvt);
        int Ed_EdEvt = this.endDate.compareTo(endDateEvt);
        int Ed_StEvt = this.endDate.compareTo(startDateEvt);
        int St_EdEvt = this.startDate.compareTo(endDateEvt);
        if (St_StEvt == 0 || Ed_StEvt == 0 || St_EdEvt == 0 || Ed_EdEvt == 0) {
            val = false;
        } else if (St_StEvt > 0 && St_EdEvt < 0) {
            val = false;
        } else if (Ed_StEvt > 0 && Ed_EdEvt < 0) {
            val = false;
        } else if (St_StEvt < 0 && Ed_EdEvt > 0) {
            val = false;
        } else if (St_StEvt > 0 && Ed_EdEvt < 0) {
            val = false;
        }
        return val;
    }

    public String getEndHour() {
        return this.endHour;
    }

    public String getPlace() {
        return this.place;
    }

    public String getStartHour() {
        return this.startHour;
    }

    public void setEndHour(String string) {
        this.endHour = string;
    }

    public void setPlace(String string) {
        this.place = string;
    }

    public void setStartHour(String string) {
        this.startHour = string;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }
}

