/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.arraypanes;

import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.core.web.util.viewgenerator.html.SimpleGraphicElement;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayCell;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayEmptyCell;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayLine;
import org.silverpeas.kernel.util.StringUtil;

public class ArrayCellText
extends ArrayCell
implements SimpleGraphicElement,
Comparable<Object> {
    private String text;
    private Object lazyInstance;
    private Function<Object, String> lazyText;
    private String color = null;
    private Comparable<?> compareOn = null;

    public ArrayCellText(String text, ArrayLine line) {
        super(text, line);
        this.text = text;
    }

    public <T> ArrayCellText(T instance, Function<T, String> lazyText, ArrayLine line) {
        super(null, line);
        this.lazyInstance = instance;
        this.lazyText = lazyText;
    }

    public String getText() {
        if (this.text == null && this.lazyInstance != null && this.lazyText != null) {
            this.text = StringUtil.defaultStringIfNotDefined((String)WebEncodeHelper.javaStringToHtmlString((String)this.lazyText.apply(this.lazyInstance)));
        }
        return this.text;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @Override
    public String getSyntax() {
        StringBuilder result = new StringBuilder();
        if (this.getColor() != null) {
            result.append(" <font color=\"").append(this.getColor()).append("\">");
            result.append(this.getText());
            result.append("</font>");
        } else {
            result.append(this.getText());
        }
        return result.toString();
    }

    public void setCompareOn(Comparable<?> comparable) {
        this.compareOn = comparable;
    }

    public Comparable<Object> getCompareOn() {
        return this.compareOn;
    }

    @Override
    public int compareTo(@Nonnull Object other) {
        if (other instanceof ArrayEmptyCell) {
            return 1;
        }
        if (!(other instanceof ArrayCellText)) {
            return 0;
        }
        ArrayCellText tmp = (ArrayCellText)other;
        if (this.getCompareOn() != null && tmp.getCompareOn() != null && this.getCompareOn().getClass().equals(tmp.getCompareOn().getClass())) {
            Comparable<Object> otherComparable = tmp.getCompareOn();
            Comparable<Object> thisComparable = this.getCompareOn();
            return thisComparable.compareTo(otherComparable);
        }
        if (this.getText() != null && tmp.getText() != null) {
            return this.getText().compareToIgnoreCase(tmp.getText());
        }
        if (this.getText() == null && tmp.getText() == null) {
            return 0;
        }
        if (this.getText() == null) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayCellText)) {
            return false;
        }
        ArrayCellText that = (ArrayCellText)o;
        return this.text.equals(that.text);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getText()).toHashCode();
    }
}

