/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.arraypanes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayColumn;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayLine;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayPane;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayPaneStatusBean;
import org.silverpeas.core.web.util.viewgenerator.html.pagination.Pagination;
import org.silverpeas.kernel.util.StringUtil;

public class AbstractArrayPane
implements ArrayPane {
    protected static final String EXPORT_URL_SERVLET_MAPPING = "/Export/ArrayPane";
    private static final int DEFAULT_SPACING = 2;
    private static final int DEFAULT_PADDING = 2;
    private List<ArrayColumn> columns;
    private List<ArrayLine> lines;
    private String title = null;
    private String summary = null;
    private String name;
    private ArrayPaneStatusBean state = null;
    private ServletRequest request = null;
    private HttpSession session = null;
    private int mSortMode = 0;
    private int maxCountOfPaginationList = -1;
    private Pagination pagination;
    private String mRoutingAddress = null;
    private boolean exportData = false;
    private String exportDataURL = null;
    private boolean movableLines = false;
    private String lineMoveCallback = null;

    static <O> O getOrderByFrom(ArrayPaneStatusBean state, String columnIndex, Map<Integer, Pair<O, O>> orderByColumnIndex) {
        int columnSort;
        Object result = null;
        int currentSortColumn = state.getSortColumn();
        boolean fromRequest = StringUtil.isInteger((String)columnIndex);
        int n = columnSort = fromRequest ? Integer.parseInt(columnIndex) : currentSortColumn;
        if (columnSort != 0) {
            Pair<O, O> orderBy = orderByColumnIndex.get(Math.abs(columnSort));
            if (orderBy != null) {
                int sortColumn;
                int n2 = sortColumn = fromRequest && Math.abs(columnSort) == Math.abs(currentSortColumn) ? currentSortColumn * -1 : columnSort;
                result = sortColumn > 0 ? orderBy.getLeft() : orderBy.getRight();
            }
        } else {
            Pair<O, O> orderBy = orderByColumnIndex.get(null);
            result = orderBy != null ? orderBy.getLeft() : null;
        }
        return (O)result;
    }

    @Override
    public void init(String name, PageContext pageContext) {
        this.init(name, pageContext.getRequest(), pageContext.getSession());
    }

    @Override
    public void init(String name, ServletRequest request, HttpSession session) {
        this.init(name, null, request, session);
    }

    @Override
    public void init(String name, String url, ServletRequest request, HttpSession session) {
        this.columns = new ArrayList<ArrayColumn>();
        this.lines = new ArrayList<ArrayLine>();
        this.name = name;
        this.setRoutingAddress(url);
        this.session = session;
        this.request = request;
        this.state = this.initState();
        String target = StringUtil.defaultStringIfNotDefined((String)request.getParameter("ArrayPaneTarget"));
        if (target.equals(name)) {
            String action = request.getParameter("ArrayPaneAction");
            if ("Sort".equals(action)) {
                this.initColumnSorting();
            } else if ("ChangePage".equals(action)) {
                this.initNbLinesPerPage();
            }
        }
        if (this.state.getSortColumn() >= 1) {
            this.setColumnToSort(this.state.getSortColumn());
        }
    }

    private ArrayPaneStatusBean initState() {
        ArrayPaneStatusBean sessionState = (ArrayPaneStatusBean)this.session.getAttribute(this.getName());
        if (sessionState == null) {
            sessionState = new ArrayPaneStatusBean();
            this.session.setAttribute(this.getName(), (Object)sessionState);
        }
        return sessionState;
    }

    private void initColumnSorting() {
        String newState = this.request.getParameter("ArrayPaneColumn");
        if (newState != null) {
            int ns = Integer.parseInt(newState);
            if (ns == this.state.getSortColumn() || ns + this.state.getSortColumn() == 0) {
                this.state.setSortColumn(-this.state.getSortColumn());
            } else {
                this.state.setSortColumn(ns);
            }
        }
    }

    private void initNbLinesPerPage() {
        String nbLines = this.request.getParameter("ItemsPerPage");
        if (StringUtil.isDefined((String)nbLines)) {
            this.state.setMaximumVisibleLine(Integer.parseInt(nbLines), true);
        }
        String index = this.request.getParameter("PaginationPaneIndex");
        this.state.setFirstVisibleLine(Integer.parseInt(index));
    }

    public ArrayPaneStatusBean getState() {
        return this.state;
    }

    @Override
    public ArrayColumn addArrayColumn(String title2) {
        ArrayColumn col = new ArrayColumn(title2, this.columns.size() + 1, this);
        this.columns.add(col);
        col.setRoutingAddress(this.mRoutingAddress);
        return col;
    }

    @Override
    public ArrayLine addArrayLine() {
        ArrayLine line = new ArrayLine(this);
        this.lines.add(line);
        return line;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title2) {
        this.title = title2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setVisibleLineNumber(int maximum) {
        this.state.setMaximumVisibleLine(maximum, false);
    }

    @Override
    public int getColumnToSort() {
        if (this.state != null) {
            return this.state.getSortColumn();
        }
        return 0;
    }

    @Override
    public void setColumnToSort(int columnNumber) {
        this.state.setSortColumn(columnNumber);
    }

    @Override
    public String print() {
        return null;
    }

    @Override
    public HttpSession getSession() {
        return this.session;
    }

    @Override
    public ServletRequest getRequest() {
        return this.request;
    }

    @Override
    public void setRoutingAddress(String address) {
        this.mRoutingAddress = address;
    }

    @Override
    public boolean getSortable() {
        return this.mSortMode == 0;
    }

    @Override
    public void setSortable(boolean sortable) {
        this.mSortMode = sortable ? 0 : 1;
    }

    @Override
    public void setLineMoveCallback(String callback) {
        this.lineMoveCallback = callback;
    }

    public int getCellSpacing() {
        return 2;
    }

    public int getCellPadding() {
        return 2;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public boolean isExportData() {
        return this.exportData;
    }

    @Override
    public void setExportData(boolean exportData) {
        this.exportData = exportData;
    }

    @Override
    public String getExportDataURL() {
        return this.exportDataURL;
    }

    @Override
    public void setExportDataURL(String exportDataURL) {
        this.exportDataURL = exportDataURL;
    }

    protected String getExportUrl() {
        if (StringUtil.isDefined((String)this.getExportDataURL())) {
            return this.getExportDataURL();
        }
        StringBuilder exportUrl = new StringBuilder();
        String contextPath = URLUtil.getApplicationURL();
        exportUrl.append(contextPath).append(EXPORT_URL_SERVLET_MAPPING);
        exportUrl.append("?type=ArrayPane&name=");
        exportUrl.append("Silverpeas_arraypane");
        return exportUrl.toString();
    }

    public boolean isMovableLines() {
        return this.movableLines;
    }

    @Override
    public void setMovableLines(boolean movableLines) {
        this.movableLines = movableLines;
    }

    public String getUrl() {
        if (this.mRoutingAddress == null) {
            String address = ((HttpServletRequest)this.getRequest()).getRequestURI();
            if ((address = address.substring(address.lastIndexOf(47) + 1)).lastIndexOf(63) >= 0) {
                address = address.substring(0, address.lastIndexOf(63));
            }
            return address;
        }
        return this.mRoutingAddress;
    }

    public String getIconsPath() {
        return GraphicElementFactory.getIconsPath();
    }

    public List<ArrayLine> getLines() {
        return this.lines;
    }

    public List<ArrayColumn> getColumns() {
        return this.columns;
    }

    protected String printSortJavascriptFunction() {
        StringBuilder sb = new StringBuilder();
        sb.append("<script type=\"text/javascript\">");
        sb.append("var fixArrayPaneWidthHelper = function(e, ui) {");
        sb.append("var clone = ui.clone(true);");
        sb.append("var cloneWidths = [];");
        sb.append("ui.children().each(function() {");
        sb.append("cloneWidths.push($(this).width());");
        sb.append("});");
        sb.append("clone.children().each(function(index) {");
        sb.append("$(this).width(cloneWidths[index]);");
        sb.append("});");
        sb.append("return clone;");
        sb.append("};");
        sb.append("$(\"#").append(this.getName()).append(" tbody\").sortable({");
        sb.append("placeholder: \"arraypane-sortable-placeholder\",");
        sb.append("cursor: \"move\",");
        sb.append("forcePlaceholderSize: true,");
        sb.append("helper: fixArrayPaneWidthHelper,");
        if (StringUtil.isDefined((String)this.lineMoveCallback)) {
            sb.append("update: function(e, ui){").append(this.lineMoveCallback).append(";}");
        }
        sb.append("}).disableSelection();");
        sb.append("</script>");
        return sb.toString();
    }

    void setPaginationList(SilverpeasList<?> paginationList) {
        this.maxCountOfPaginationList = (int)paginationList.originalListSize();
    }

    protected boolean isPaginationOptimized() {
        return this.maxCountOfPaginationList >= 0;
    }

    protected int getNbItems() {
        return this.isPaginationOptimized() ? this.maxCountOfPaginationList : this.getLines().size();
    }

    Pagination getPagination(int nbItems) {
        if (this.pagination == null) {
            GraphicElementFactory gef = (GraphicElementFactory)this.getSession().getAttribute("SessionGraphicElementFactory");
            this.pagination = gef.getPagination(nbItems, this.getState().getMaximumVisibleLine(), this.getState().getFirstVisibleLine());
        } else if (this.pagination.getNbItems() != nbItems) {
            this.pagination.init(nbItems, this.getState().getMaximumVisibleLine(), this.getState().getFirstVisibleLine());
        }
        return this.pagination;
    }
}

