/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.template.SilverpeasTemplates;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.kernel.bundle.SilverpeasBundle;

public class JavascriptBundleProducer {
    private String jsBundleVariableName = "Bundle";
    private Map<String, String> keyMessages = new LinkedHashMap<String, String>();

    private JavascriptBundleProducer() {
    }

    static String fromCoreTemplate(String pathSuffix, String templateName, String language) {
        SilverpeasTemplate bundle = SilverpeasTemplates.createSilverpeasTemplateOnCore((String)pathSuffix);
        return bundle.applyFileTemplate(templateName + "_" + DisplayI18NHelper.verifyLanguage((String)language));
    }

    public static JavascriptBundleProducer bundleVariableName(String jsBundleVariableName) {
        return new JavascriptBundleProducer().withBundleVariableName(jsBundleVariableName);
    }

    private JavascriptBundleProducer withBundleVariableName(String jsBundleVariableName) {
        this.jsBundleVariableName = jsBundleVariableName;
        return this;
    }

    public JavascriptBundleProducer add(SilverpeasBundle bundle, String ... keys) {
        for (String key : keys) {
            this.add(key, bundle.getString(key));
        }
        return this;
    }

    public JavascriptBundleProducer add(String key, String value) {
        this.keyMessages.put(key, "\"" + WebEncodeHelper.javaStringToJsString((String)value) + "\"");
        return this;
    }

    public String produce() {
        StringBuilder js = new StringBuilder();
        js.append("window.").append(this.jsBundleVariableName).append("=new SilverpeasPluginBundle({");
        Iterator<Map.Entry<String, String>> keyMessageIt = this.keyMessages.entrySet().iterator();
        while (keyMessageIt.hasNext()) {
            Map.Entry<String, String> keyMessage = keyMessageIt.next();
            js.append("\"").append(keyMessage.getKey()).append("\":");
            js.append(keyMessage.getValue());
            if (!keyMessageIt.hasNext()) continue;
            js.append(",");
        }
        js.append("});");
        return js.toString();
    }
}

