/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.core.web.admin.migration.UIUserCache;

public abstract class SelectableUIEntity<D> {
    private final D data;
    private final Set<String> selectedIds;
    private Boolean selected;

    public SelectableUIEntity(D data) {
        this(data, null);
    }

    public SelectableUIEntity(D data, Set<String> selectedIds) {
        this.data = data;
        this.selectedIds = selectedIds;
        this.selected = selectedIds != null ? null : Boolean.valueOf(false);
    }

    public static <W extends SelectableUIEntity, I> SilverpeasList<W> convert(List<I> dataList, Function<I, W> converter) {
        SilverpeasList list = SilverpeasList.wrap(dataList);
        return (SilverpeasList)dataList.stream().map(converter).collect(SilverpeasList.collector((List)list));
    }

    public abstract String getId();

    public D getData() {
        return this.data;
    }

    public boolean isSelected() {
        if (this.selected == null) {
            this.selected = this.selectedIds.contains(this.getId());
        }
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    protected User getUserByIdFromCache(String id) {
        return UIUserCache.getById(id);
    }
}

