/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.portlets.context.window.impl;

import com.sun.portal.container.EntityID;
import com.sun.portal.container.PortletID;
import com.sun.portal.portletcontainer.common.PortletPreferencesUtility;
import com.sun.portal.portletcontainer.common.PreferencesValidatorSetter;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import javax.servlet.http.HttpServletRequest;

public class PortletPreferencesImpl
implements PortletPreferences,
PreferencesValidatorSetter {
    private String portletWindowName;
    private PortletID portletID;
    private String userID;
    private PreferencesValidator preferencesValidator;
    private PortletRegistryContext portletRegistryContext;
    private HttpServletRequest request;
    private ResourceBundle bundle;
    private Map<String, String> rbPreferenceNames;
    private boolean useRBPreferenceName;
    private boolean useRBPreferenceValue;
    private boolean readOnly;
    protected Map predefinedPrefReadOnlyMap;
    protected Map userPrefMap;
    protected Map defaultMap;
    protected Set modifiedList;
    private static final Logger logger = Logger.getLogger("org.silverpeas.core.web.portlets.context.window.impl", "org.silverpeas.portlets.PCCTXLogMessages");

    public PortletPreferencesImpl(HttpServletRequest request, PortletRegistryContext portletRegistryContext, EntityID entityID, String userID, ResourceBundle bundle, boolean isReadOnly) {
        this.portletWindowName = entityID.getPortletWindowName();
        this.portletID = entityID.getPortletID();
        this.userID = userID;
        this.portletRegistryContext = portletRegistryContext;
        this.request = request;
        this.bundle = bundle;
        this.useRBPreferenceName = false;
        this.useRBPreferenceValue = false;
        if (this.bundle != null) {
            Enumeration<String> keys = this.bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (key.startsWith("javax.portlet.preference.name.")) {
                    this.rbPreferenceNames = new HashMap<String, String>();
                    this.useRBPreferenceName = true;
                    continue;
                }
                if (!key.startsWith("javax.portlet.preference.value.")) continue;
                this.useRBPreferenceValue = true;
            }
        }
        this.readOnly = isReadOnly;
        this.modifiedList = new HashSet();
        try {
            this.predefinedPrefReadOnlyMap = portletRegistryContext.getPreferencesReadOnly(this.portletWindowName, this.userID);
        }
        catch (Exception ioe) {
            logger.log(Level.WARNING, "PSPL_PCCTXCSPPCI0013 : {0}", ioe.getMessage());
        }
        try {
            this.userPrefMap = portletRegistryContext.getPreferences(this.portletWindowName, this.userID);
            this.defaultMap = portletRegistryContext.getPreferences(this.portletWindowName, "default");
        }
        catch (Exception ioe) {
            logger.log(Level.SEVERE, "PSPL_PCCTXCSPPCI0013", ioe);
        }
    }

    public boolean isReadOnly(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.getIsReadOnly(key);
    }

    public String getValue(String key, String def) {
        String[] defs = new String[]{def};
        String[] values = this.getValues(key, defs);
        if (values == null || values.length == 0) {
            return def;
        }
        return values[0];
    }

    public String[] getValues(String key, String[] def) {
        String value = this.getPrefValue(key, this.arrayToString(def));
        String[] prefs = this.stringToArray(value);
        if (prefs == null || prefs.length == 0) {
            return def;
        }
        int length = prefs.length;
        for (int i = 0; i < length; ++i) {
            if ("@@$$NULL_STRING$$@@".equals(prefs[i])) {
                prefs[i] = null;
                continue;
            }
            String prefName = null;
            if (this.rbPreferenceNames != null) {
                prefName = this.rbPreferenceNames.get(key);
            }
            if (prefName == null) {
                prefName = key;
            }
            prefs[i] = this.getPreferenceValueFromRB(prefName, prefs[i]);
        }
        return prefs;
    }

    public void setValue(String key, String value) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (this.readOnly) {
            throw new ReadOnlyException("");
        }
        if (this.getIsReadOnly(key)) {
            throw new ReadOnlyException("");
        }
        this.userPrefMap.put(key, value);
        this.modifiedList.add(key);
    }

    public void setValues(String key, String[] values) throws ReadOnlyException {
        this.setValue(key, this.arrayToString(values));
    }

    public Enumeration<String> getNames() {
        Set names = this.userPrefMap.keySet();
        ArrayList<String> list = new ArrayList<String>();
        for (String name : names) {
            String prefName = this.getPreferenceNameFromRB(name);
            if (this.rbPreferenceNames != null) {
                this.rbPreferenceNames.put(prefName, name);
            }
            list.add(prefName);
        }
        return Collections.enumeration(list);
    }

    public Map<String, String[]> getMap() {
        HashMap<String, String[]> prefMap = new HashMap<String, String[]>();
        Enumeration<String> names = this.getNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            String prefName = null;
            if (this.rbPreferenceNames != null) {
                prefName = this.rbPreferenceNames.get(name);
            }
            if (prefName == null) {
                prefName = name;
            }
            prefMap.put(name, this.getValues(prefName, null));
        }
        if (prefMap.size() > 0) {
            return prefMap;
        }
        return Collections.EMPTY_MAP;
    }

    public void reset(String key) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        String prefName = null;
        if (this.rbPreferenceNames != null) {
            prefName = this.rbPreferenceNames.get(key);
        }
        if (prefName == null) {
            prefName = key;
        }
        if (this.getIsReadOnly(prefName)) {
            throw new ReadOnlyException("");
        }
        this.userPrefMap.put(prefName, this.getDefault(prefName));
        this.modifiedList.add(prefName);
    }

    public void store() throws IOException, ValidatorException {
        String lifecyclePhase = (String)this.request.getAttribute("javax.portlet.lifecycle_phase");
        if ("RENDER_PHASE".equals(lifecyclePhase)) {
            throw new IllegalStateException("Not allowed to store preferences during render");
        }
        if (this.preferencesValidator != null) {
            this.preferencesValidator.validate((PortletPreferences)this);
        }
        this.savePrefMap();
    }

    public void setPreferencesValidator(PreferencesValidator pv) {
        this.preferencesValidator = pv;
    }

    private String getPrefValue(String key, String def) {
        String pref = null;
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.loadPrefMap(key, def);
        pref = (String)this.userPrefMap.get(key);
        return pref;
    }

    private String getPreferenceNameFromRB(String key) {
        if (!this.useRBPreferenceName) {
            return key;
        }
        StringBuilder attribute = new StringBuilder();
        attribute.append("javax.portlet.preference.name.");
        attribute.append(key);
        try {
            return this.bundle.getString(attribute.toString());
        }
        catch (MissingResourceException mse) {
            return key;
        }
    }

    private String getPreferenceValueFromRB(String key, String value) {
        if (!this.useRBPreferenceValue) {
            return value;
        }
        StringBuilder attribute = new StringBuilder();
        attribute.append("javax.portlet.preference.value.");
        attribute.append(key);
        attribute.append(".");
        attribute.append(value);
        try {
            return this.bundle.getString(attribute.toString());
        }
        catch (MissingResourceException mse) {
            return value;
        }
    }

    private String[] stringToArray(String value) {
        List valueArray = PortletPreferencesUtility.getPreferenceValues((String)value);
        return valueArray.toArray(new String[valueArray.size()]);
    }

    private String arrayToString(String[] values) {
        return PortletPreferencesUtility.getPreferenceString((String[])values);
    }

    protected HashMap cloneMap(Map original) {
        HashMap clone = null;
        if (original instanceof HashMap) {
            return (HashMap)((HashMap)original).clone();
        }
        clone = new HashMap();
        for (Map.Entry entry : original.entrySet()) {
            String name = (String)entry.getKey();
            clone.put(name, entry.getValue());
        }
        return clone;
    }

    protected void loadPrefMap(String prefName, String def) {
        if (!this.userPrefMap.containsKey(prefName)) {
            String pref = (String)this.defaultMap.get(prefName);
            if (pref == null) {
                pref = def;
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "PSPL_PCCTXCSPPCI0014", new Object[]{prefName, pref});
            }
            this.userPrefMap.put(prefName, pref);
        }
    }

    protected void savePrefMap() {
        Iterator iter = this.modifiedList.iterator();
        HashMap<String, String> prefMap = new HashMap<String, String>();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)this.userPrefMap.get(key);
            prefMap.put(key, value);
            if (!logger.isLoggable(Level.INFO)) continue;
            logger.log(Level.INFO, "PSPL_PCCTXCSPPCI0015", new Object[]{key, value});
        }
        this.writePortletPreferences(prefMap);
        this.modifiedList.clear();
    }

    private boolean getIsReadOnly(String key) {
        String isReadOnly;
        Boolean retval = Boolean.FALSE;
        if (this.predefinedPrefReadOnlyMap != null && (isReadOnly = (String)this.predefinedPrefReadOnlyMap.get(key)) != null) {
            retval = Boolean.valueOf(isReadOnly);
        }
        return retval;
    }

    private String getDefault(String key) {
        String def = null;
        if (this.defaultMap != null) {
            def = (String)this.defaultMap.get(key);
        }
        return def;
    }

    private void writePortletPreferences(Map prefMap) {
        block6: {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "PSPL_PCCTXCSPPCI0016", new Object[]{this.userID, this.portletID, this.portletWindowName});
                }
                if (this.portletID != null) {
                    this.portletRegistryContext.savePreferences(this.portletID.toString(), this.portletWindowName, this.userID, prefMap);
                } else if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "PSPL_PCCTXCSPPCI0017", new String[]{this.userID, this.portletWindowName});
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block6;
                logger.log(Level.SEVERE, "PSPL_PCCTXCSPPCI0018", new Object[]{this.userID, this.portletID, this.portletWindowName});
            }
        }
    }
}

