/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.webcomponent;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.web.mvc.webcomponent.Path;
import org.silverpeas.core.web.mvc.webcomponent.WebComponentRequestContext;
import org.silverpeas.kernel.util.StringUtil;

public class ResponseContentProducer {
    private ResponseContentProducer() {
    }

    static void produce(WebComponentRequestContext context, Path pathToPerform) {
        String contentType = pathToPerform.getProduces().value()[0];
        HttpServletResponse response = context.getResponse();
        response.setHeader("Content-Type", contentType + "; charset=UTF-8");
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", -1L);
        if (!contentType.equals("application/json")) {
            throw new IllegalArgumentException("only JSON producing is handled");
        }
        ResponseContentProducer.handleJson(context, pathToPerform);
    }

    private static void handleJson(WebComponentRequestContext context, Path pathToPerform) {
        Object content = ResponseContentProducer.invoke(context, pathToPerform);
        String responseContent = "";
        if (content instanceof String) {
            responseContent = (String)content;
        } else if (content != null) {
            responseContent = JSONCodec.encode((Object)content);
        }
        if (StringUtil.isDefined((String)responseContent)) {
            try {
                context.getResponse().getWriter().append(responseContent);
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
            }
        }
    }

    private static Object invoke(WebComponentRequestContext context, Path pathToPerform) {
        try {
            return pathToPerform.getResourceMethod().invoke(context.getController(), context);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (e.getCause() instanceof WebApplicationException) {
                throw (WebApplicationException)e.getCause();
            }
            throw new WebApplicationException("error during " + pathToPerform.getResourceMethod().getName() + " invocation", (Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
        }
    }
}

