/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.util;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import org.silverpeas.core.exception.FromModule;
import org.silverpeas.core.exception.SilverpeasException;
import org.silverpeas.kernel.logging.SilverLogger;

public class HomePageUtil {
    public static String getMessageToDisplay(Throwable exception, String language) {
        if (exception == null) {
            return "Internal error : No error in parameter's request";
        }
        Collection exceptions = SilverpeasException.getChainedExceptions((Throwable)exception);
        Iterator iterator = exceptions.iterator();
        if (iterator.hasNext()) {
            Throwable toDisplayException = (Throwable)iterator.next();
            return HomePageUtil.getMessageFromException(toDisplayException, language);
        }
        return exception.getMessage();
    }

    public static String getMessagesToDisplay(Throwable exception, String language) {
        if (exception == null) {
            return "Internal error : No error in parameter's request";
        }
        Collection exceptions = SilverpeasException.getChainedExceptions((Throwable)exception);
        StringBuilder result = new StringBuilder();
        for (Throwable toDisplayException : exceptions) {
            if (toDisplayException instanceof RemoteException) continue;
            if (result.length() > 0) {
                result.append("<BR>");
            }
            result.append(HomePageUtil.getMessageFromException(toDisplayException, language));
        }
        return result.toString();
    }

    public static String getMessageFromException(Throwable toDisplayException, String language) {
        if (toDisplayException.getMessage() == null) {
            return toDisplayException.getClass().getName();
        }
        if (toDisplayException instanceof FromModule) {
            return ((FromModule)toDisplayException).getMessageLang(language);
        }
        if (toDisplayException instanceof RemoteException) {
            return HomePageUtil.getMessageFromException(((RemoteException)toDisplayException).detail, language);
        }
        return toDisplayException.getMessage();
    }

    public static Throwable getExceptionToDisplay(Throwable exception) {
        Throwable toDisplayException = null;
        if (exception != null) {
            Collection exceptions = SilverpeasException.getChainedExceptions((Throwable)exception);
            Iterator iterator = exceptions.iterator();
            while (iterator.hasNext()) {
                Throwable exception1;
                toDisplayException = exception1 = (Throwable)iterator.next();
            }
        }
        return toDisplayException;
    }

    public static void traceException(Throwable exception) {
        Throwable lastEx = HomePageUtil.getExceptionToDisplay(exception);
        if (lastEx == null || lastEx.getMessage() == null || !lastEx.getMessage().contains("Connection reset by peer: socket write error") || lastEx.getMessage().contains("SQL")) {
            if (exception instanceof FromModule) {
                ((FromModule)exception).traceException();
            } else {
                boolean bFound = false;
                if (exception != null) {
                    Collection exceptions = SilverpeasException.getChainedExceptions((Throwable)exception);
                    for (Throwable exception1 : exceptions) {
                        Throwable parcNested = exception1;
                        if (!(parcNested instanceof FromModule)) continue;
                        bFound = true;
                        ((FromModule)parcNested).traceException();
                    }
                }
                if (!bFound) {
                    SilverLogger.getLogger(HomePageUtil.class).error(exception);
                }
            }
        }
    }
}

