/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.controller;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.kernel.util.StringUtil;

@Singleton
public class SilverpeasWebUtil {
    @Inject
    private OrganizationController organizationController;

    public static SilverpeasWebUtil get() {
        return (SilverpeasWebUtil)ServiceProvider.getService(SilverpeasWebUtil.class, (Annotation[])new Annotation[0]);
    }

    protected SilverpeasWebUtil() {
    }

    public OrganizationController getOrganisationController() {
        return this.organizationController;
    }

    public MainSessionController getMainSessionController(HttpServletRequest request) {
        return (MainSessionController)request.getSession().getAttribute("SilverSessionController");
    }

    public String[] getComponentId(HttpServletRequest request) {
        String componentId;
        String function;
        String spaceId;
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            spaceId = null;
            pathInfo = pathInfo.substring(1);
            function = pathInfo.substring(pathInfo.indexOf(47) + 1, pathInfo.length());
            if (pathInfo.startsWith("jsp")) {
                componentId = null;
            } else {
                if (pathInfo.contains("WA")) {
                    String sAndCId = pathInfo.substring(0, pathInfo.indexOf(47));
                    spaceId = sAndCId.substring(0, sAndCId.indexOf(95));
                    componentId = sAndCId.substring(spaceId.length() + 1, sAndCId.length());
                } else {
                    componentId = pathInfo.substring(0, pathInfo.indexOf(47));
                }
                if ((function.startsWith("Main") || function.startsWith("searchResult") || function.equalsIgnoreCase("searchresult") || function.startsWith("portlet") || function.equals("GoToFilesTab")) && !PersonalComponentInstance.from((String)componentId).isPresent()) {
                    ComponentInstLight component = this.getOrganisationController().getComponentInstLight(componentId);
                    spaceId = component.getDomainFatherId();
                }
            }
        } else {
            spaceId = "-1";
            componentId = "-1";
            function = "Error";
        }
        return new String[]{spaceId, componentId, function};
    }

    public String[] getRoles(HttpServletRequest request) {
        MainSessionController controller = this.getMainSessionController(request);
        if (controller != null) {
            return this.getOrganisationController().getUserProfiles(controller.getUserId(), this.getComponentId(request)[1]);
        }
        return ArrayUtil.emptyStringArray();
    }

    public String getContentLanguage(HttpServletRequest request) {
        MainSessionController mainSessionCtrl;
        String contentLanguage = (String)request.getAttribute("ContentLanguage");
        if (StringUtil.isNotDefined((String)contentLanguage)) {
            contentLanguage = request.getParameter("ContentLanguage");
        }
        if (StringUtil.isNotDefined((String)contentLanguage)) {
            contentLanguage = I18NHelper.DEFAULT_LANGUAGE;
        }
        if (StringUtil.isNotDefined((String)contentLanguage) && (mainSessionCtrl = this.getMainSessionController(request)) != null) {
            contentLanguage = mainSessionCtrl.getFavoriteLanguage();
        }
        return contentLanguage;
    }

    public String getUserLanguage(HttpServletRequest request) {
        return Optional.ofNullable(User.getCurrentRequester()).filter(Predicate.not(User::isAnonymous)).map(r -> r.getUserPreferences().getLanguage()).orElseGet(() -> {
            String userLanguage = (String)request.getAttribute("language");
            if (StringUtil.isNotDefined((String)userLanguage)) {
                userLanguage = (String)request.getAttribute("userLanguage");
            }
            if (StringUtil.isNotDefined((String)userLanguage) && request.getLocale() != null) {
                userLanguage = request.getLocale().getLanguage();
            }
            return DisplayI18NHelper.verifyLanguage((String)userLanguage);
        });
    }
}

