/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc;

import javax.inject.Inject;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.cache.service.SessionCacheAccessor;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.security.session.SessionManagement;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.session.HTTPSessionInfo;
import org.silverpeas.core.webapi.notification.sse.SilverpeasServerSentEventServlet;
import org.silverpeas.kernel.logging.SilverLogger;

public class SilverListener
implements HttpSessionListener,
ServletContextListener,
ServletRequestListener {
    @Inject
    private SessionManagement sessionManager;

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        this.remove(event);
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    public void contextInitialized(ServletContextEvent event) {
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        this.clearThreadCache();
    }

    public void requestInitialized(ServletRequestEvent sre) {
        Runnable setupSessionCache;
        this.clearThreadCache();
        ServletRequest request = sre.getServletRequest();
        if (!(request instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        URLUtil.setCurrentServerUrl((HttpServletRequest)httpRequest);
        if (SilverpeasServerSentEventServlet.isSseRequest(httpRequest)) {
            return;
        }
        HttpSession httpSession = httpRequest.getSession(false);
        if (httpSession == null) {
            return;
        }
        SessionCacheAccessor sessionCacheAccessor = CacheAccessorProvider.getSessionCacheAccessor();
        SessionInfo sessionInfo = this.sessionManager.getSessionInfo(httpSession.getId());
        if (sessionInfo.isDefined()) {
            if (sessionInfo instanceof HTTPSessionInfo && !sessionInfo.isAnonymous()) {
                ((HTTPSessionInfo)sessionInfo).setHttpSession(httpSession);
            }
            setupSessionCache = () -> sessionCacheAccessor.setCurrentSessionCache(sessionInfo.getCache());
        } else {
            MainSessionController mainSessionController = MainSessionController.getInstance(httpSession);
            if (mainSessionController != null && mainSessionController.getCurrentUserDetail() != null && mainSessionController.getCurrentUserDetail().isAnonymous()) {
                setupSessionCache = () -> sessionCacheAccessor.newSessionCache((User)mainSessionController.getCurrentUserDetail());
            } else {
                SilverLogger.getLogger((Object)this).debug("No identified user session attached to request ''{0}'' ", new Object[]{httpRequest.getRequestURI()});
                return;
            }
        }
        try {
            setupSessionCache.run();
        }
        catch (RuntimeException e) {
            SilverLogger.getLogger((Object)this).warn("request ''{0}'' accessing attributes on closed session ({1})", new Object[]{httpRequest.getRequestURI(), e.getMessage(), e});
        }
    }

    private void remove(HttpSessionEvent event) {
        String sessionId = event.getSession().getId();
        this.sessionManager.closeSession(sessionId);
        SilverLogger.getLogger((Object)this).debug("Session with id {0} has just been closed", new Object[]{sessionId});
    }

    private void clearThreadCache() {
        CacheAccessorProvider.getThreadCacheAccessor().getCache().clear();
    }
}

