/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.http.ServletSafeContentRedirect;
import org.silverpeas.core.web.look.proxy.SpaceHomepageProxyManager;

public abstract class SafeContentRedirect {
    final HttpServletResponse response;
    final HttpServletRequest request;

    SafeContentRedirect(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public static ServletSafeContentRedirect fromServlet(HttpServletRequest request, HttpServletResponse response) {
        return new ServletSafeContentRedirect(request, response);
    }

    public String getDestination(String url) {
        if (this.request.getAttribute("IsInternalLink") == null && (url.startsWith(URLUtil.getFullApplicationURL((HttpServletRequest)this.request)) || url.startsWith(URLUtil.getApplicationURL()))) {
            this.request.setAttribute("IsInternalLink", (Object)true);
            this.request.setAttribute("IsPermalink", (Object)URLUtil.isPermalink((String)url));
        }
        this.request.setAttribute("URL", (Object)SpaceHomepageProxyManager.get().setParameterForUrlRedirect(url));
        return "/util/jsp/safeContentRedirection.jsp";
    }
}

