/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.calendar;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.silverpeas.core.date.period.PeriodType;

public enum CalendarViewType {
    YEARLY(PeriodType.year, "listYear", ""),
    MONTHLY(PeriodType.month, "month", "listMonth"),
    WEEKLY(PeriodType.week, "agendaWeek", "listWeek"),
    DAILY(PeriodType.day, "agendaDay", "listDay"),
    NEXT_EVENTS(PeriodType.unknown, "nextevents", "");

    private PeriodType periodeType;
    private String calendarView;
    private String listView;

    private CalendarViewType(PeriodType periodeType, String viewMode, String listView) {
        this.periodeType = periodeType;
        this.calendarView = viewMode;
        this.listView = listView;
    }

    @JsonCreator
    public static CalendarViewType from(String name) {
        if (name != null) {
            for (CalendarViewType viewType : CalendarViewType.values()) {
                if (!name.equalsIgnoreCase(viewType.name()) && !name.equalsIgnoreCase(viewType.toString())) continue;
                return viewType;
            }
        }
        return null;
    }

    public String toString() {
        return this.calendarView;
    }

    public boolean isYearlyView() {
        return this == YEARLY;
    }

    public boolean isMonthlyView() {
        return this == MONTHLY;
    }

    public boolean isWeeklyView() {
        return this == WEEKLY;
    }

    public boolean isDailyView() {
        return this == DAILY;
    }

    public boolean isNextEventsView() {
        return this == NEXT_EVENTS;
    }

    @JsonValue
    public String getName() {
        return this.name();
    }

    public PeriodType getPeriodeType() {
        return this.periodeType;
    }
}

