/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.calendar;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.ecs.xhtml.script;
import org.silverpeas.core.date.period.Period;
import org.silverpeas.core.date.period.PeriodType;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.web.calendar.CalendarDay;
import org.silverpeas.core.web.calendar.CalendarPeriod;
import org.silverpeas.core.web.calendar.CalendarViewType;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class CalendarTimeWindowViewContext
implements Serializable {
    private static final EnumSet<PeriodType> DISPLAY_WEEK_PERIODS = EnumSet.of(PeriodType.week, PeriodType.day);
    private String locale = null;
    private ZoneId zoneId = null;
    private final String componentInstanceId;
    private List<CalendarViewType> availableViewTypes = Arrays.asList(CalendarViewType.NEXT_EVENTS, CalendarViewType.DAILY, CalendarViewType.WEEKLY, CalendarViewType.MONTHLY, CalendarViewType.YEARLY);
    private CalendarViewType viewType = CalendarViewType.MONTHLY;
    private boolean listViewMode = false;
    private CalendarDay referenceDay;
    private CalendarPeriod referencePeriod;
    private boolean withWeekend = true;

    public CalendarTimeWindowViewContext(String componentInstanceId, String locale, ZoneId zoneId) {
        this.componentInstanceId = componentInstanceId;
        this.locale = locale;
        this.zoneId = zoneId;
        this.setReferenceDay(DateUtil.getDate());
    }

    public String toJSonScript(String jsVariableName) {
        return new script().setType("text/javascript").addElement("var " + jsVariableName + " = " + this.getAsJSonString() + ";").toString();
    }

    @XmlTransient
    public String getAsJSonString() {
        return JSONCodec.encode((Object)this);
    }

    public CalendarTimeWindowViewContext resetFilters() {
        this.setViewType(CalendarViewType.MONTHLY);
        this.today();
        return this;
    }

    public String getComponentInstanceId() {
        return this.componentInstanceId;
    }

    public List<CalendarViewType> getAvailableViewTypes() {
        return this.availableViewTypes;
    }

    public void setAvailableViewTypes(List<CalendarViewType> availableViewTypes) {
        this.availableViewTypes = availableViewTypes;
    }

    public CalendarViewType getViewType() {
        return this.viewType;
    }

    public void setViewType(CalendarViewType viewType) {
        this.viewType = viewType;
        this.setReferenceDay(this.referenceDay.getDate());
    }

    public boolean isListViewMode() {
        return this.listViewMode;
    }

    public void setListViewMode(boolean listViewMode) {
        this.listViewMode = listViewMode;
    }

    public CalendarPeriod getReferencePeriod() {
        return this.referencePeriod;
    }

    public String getReferencePeriodLabel() {
        return CalendarTimeWindowViewContext.getPeriodLabel(this.getReferencePeriod(), this.locale);
    }

    public CalendarDay getReferenceDay() {
        return this.referenceDay;
    }

    public String getFormattedReferenceDay() {
        return DateUtil.getOutputDate((Date)this.getReferenceDay().getDate(), (String)this.locale);
    }

    public void setReferenceDay(Date date) {
        this.setReferenceDay(date, 0);
    }

    private void setReferenceDay(Date date, int offset) {
        Date referenceDate;
        Calendar cal = DateUtil.convert((Date)date, (String)this.locale);
        if (!this.withWeekend && (this.viewType.equals((Object)CalendarViewType.WEEKLY) || this.viewType.equals((Object)CalendarViewType.DAILY))) {
            switch (cal.get(7)) {
                case 7: {
                    if (7 == DateUtil.getFirstDayOfWeek((String)this.locale)) {
                        referenceDate = DateUtils.addDays((Date)date, (int)(offset >= 0 ? 2 : -1));
                        break;
                    }
                    referenceDate = DateUtils.addDays((Date)date, (int)(offset > 0 ? 2 : -1));
                    break;
                }
                case 1: {
                    if (1 == DateUtil.getFirstDayOfWeek((String)this.locale)) {
                        referenceDate = DateUtils.addDays((Date)date, (int)(offset >= 0 ? 1 : -2));
                        break;
                    }
                    referenceDate = DateUtils.addDays((Date)date, (int)(offset > 0 ? 1 : -2));
                    break;
                }
                default: {
                    referenceDate = date;
                    break;
                }
            }
        } else {
            referenceDate = date;
        }
        this.referenceDay = new CalendarDay(referenceDate, this.locale);
        this.referencePeriod = CalendarPeriod.from(Period.from((Date)referenceDate, (PeriodType)this.viewType.getPeriodeType(), (String)this.locale), this.locale);
    }

    public void previous() {
        this.moveReferenceDate(-1);
    }

    public void next() {
        this.moveReferenceDate(1);
    }

    private void moveReferenceDate(int offset) {
        switch (this.viewType) {
            case YEARLY: {
                this.setReferenceDay(DateUtils.addYears((Date)this.referenceDay.getDate(), (int)offset), offset);
                break;
            }
            case MONTHLY: {
                this.setReferenceDay(DateUtils.addMonths((Date)this.referenceDay.getDate(), (int)offset), offset);
                break;
            }
            case WEEKLY: {
                this.setReferenceDay(DateUtils.addWeeks((Date)this.referenceDay.getDate(), (int)offset), offset);
                break;
            }
            case DAILY: {
                this.setReferenceDay(DateUtils.addDays((Date)this.referenceDay.getDate(), (int)offset), offset);
            }
        }
    }

    public void today() {
        this.setReferenceDay(DateUtil.getDate());
    }

    public boolean isWithWeekend() {
        return this.withWeekend;
    }

    public void setWithWeekend(boolean withWeekend) {
        this.withWeekend = withWeekend;
    }

    public int getFirstDayOfWeek() {
        return DateUtil.getFirstDayOfWeek((String)this.locale);
    }

    protected static LocalizationBundle getBundle(String language) {
        return ResourceLocator.getGeneralLocalizationBundle((String)language);
    }

    public static String getPeriodLabel(CalendarPeriod period, String language) {
        LocalizationBundle bundle = CalendarTimeWindowViewContext.getBundle(language);
        StringBuilder periodLabel = new StringBuilder();
        boolean displayWeek = DISPLAY_WEEK_PERIODS.contains(period.getPeriodType());
        if (period.getPeriodType().isDay()) {
            periodLabel.append(DateUtil.getOutputDate((Date)period.getBeginDate().getDate(), (String)language));
        } else if (period.getPeriodType().isWeek()) {
            periodLabel.append(bundle.getString("GML.mois" + period.getBeginDate().getMonth()));
            if (period.getBeginDate().getMonth() != period.getEndDate().getMonth()) {
                if (period.getBeginDate().getYear() != period.getEndDate().getYear()) {
                    periodLabel.append(" ").append(period.getBeginDate().getYear());
                }
                periodLabel.append(" / ").append(bundle.getString("GML.mois" + period.getEndDate().getMonth()));
            }
            periodLabel.append(" ").append(period.getEndDate().getYear());
        } else if (period.getPeriodType().isMonth()) {
            periodLabel.append(bundle.getString("GML.mois" + period.getBeginDate().getMonth())).append(" ").append(period.getBeginDate().getYear());
        } else if (period.getPeriodType().isYear()) {
            periodLabel.append(period.getBeginDate().getYear());
        }
        if (displayWeek) {
            periodLabel.append(" - ").append(bundle.getString("GML.week")).append(' ').append(period.getBeginDate().getWeekOfYear());
        }
        return periodLabel.toString();
    }

    @XmlElement(name="zoneId")
    public String getZoneIdAsString() {
        return this.getZoneId().toString();
    }

    @XmlTransient
    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }
}

