/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication.credentials;

import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.security.authentication.AuthDomain;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.security.authentication.password.ForgottenPasswordException;
import org.silverpeas.core.security.authentication.password.ForgottenPasswordMailParameters;
import org.silverpeas.core.web.authentication.credentials.CredentialsFunctionFromLoginHandler;

@Service
public class ForgotPasswordHandler
extends CredentialsFunctionFromLoginHandler {
    @Override
    public String getFunction() {
        return "ForgotPassword";
    }

    @Override
    public String doAction(HttpServletRequest request) {
        CredentialsFunctionFromLoginHandler.LoginData loginData = this.fetchLoginData(request);
        if (loginData.isInvalid()) {
            request.setAttribute("login", (Object)loginData.getLoginId());
            request.setAttribute("domain", (Object)loginData.getDomainName());
            return this.getGeneral().getString("forgottenPasswordChangeAllowed");
        }
        CredentialsFunctionFromLoginHandler.ValidLoginData validLogin = (CredentialsFunctionFromLoginHandler.ValidLoginData)loginData;
        User user = validLogin.getUser();
        AuthDomain domain = validLogin.getDomain();
        request.setAttribute("userLanguage", (Object)user.getUserPreferences().getLanguage());
        try {
            if (domain.getCredentialsChangePolicy().canPasswordBeChanged()) {
                return this.sendUserResetMail(request, user.getLogin(), domain.getId(), user.getId());
            }
            return this.getGeneral().getString("forgottenPasswordChangeNotAllowed");
        }
        catch (ForgottenPasswordException fpe) {
            return this.forgottenPasswordError(request, fpe);
        }
    }

    private String sendUserResetMail(HttpServletRequest request, String login, String domainId, String userId) throws ForgottenPasswordException {
        try {
            ForgottenPasswordMailParameters parameters = this.getMailParameters(userId);
            parameters.setLink(this.getContextPath(request) + "/ResetPassword?key=" + this.getAuthenticationKey(login, domainId));
            this.getForgottenPasswordMailManager().sendResetPasswordRequestMail(parameters);
            return this.getGeneral().getString("forgottenPasswordChangeAllowed");
        }
        catch (AdminException | AuthenticationException e) {
            throw new ForgottenPasswordException("CredentialsServlet.forgotPasswordHandler.doAction()", "forgottenPassword.EX_GET_USER_DETAIL", "userId=" + userId, (Exception)e);
        }
    }

    private String getAuthenticationKey(String login, String domainId) throws AuthenticationException {
        return this.getAuthenticator().getAuthToken(AuthenticationCredential.newWithAsLogin((String)login).withAsDomainId(domainId));
    }
}

