/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.user;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueIntegerIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.workflow.api.user.UserInfo;
import org.silverpeas.core.workflow.api.user.UserSettings;
import org.silverpeas.core.workflow.engine.user.UserInfoImpl;
import org.silverpeas.kernel.logging.SilverLogger;

@Entity
@Table(name="sb_workflow_usersettings")
@AttributeOverride(name="id", column=@Column(name="settingsid"))
@NamedQuery(name="findByUserAndComponent", query="select s from UserSettingsImpl s where s.userId = :userId and s.peasId = :componentId")
public class UserSettingsImpl
extends BasicJpaEntity<UserSettingsImpl, UniqueIntegerIdentifier>
implements UserSettings {
    @Column
    private String userId = null;
    @Column
    private String peasId = null;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="userSettings")
    private List<UserInfoImpl> userInfos = null;

    public UserSettingsImpl() {
        this.reset();
    }

    public UserSettingsImpl(String userId, String peasId) {
        this.userId = userId;
        this.peasId = peasId;
        this.reset();
    }

    @Override
    public boolean isValid() {
        return CollectionUtil.isNotEmpty(this.userInfos);
    }

    public void reset() {
        this.userInfos = new ArrayList<UserInfoImpl>();
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getComponentId() {
        return this.peasId;
    }

    @Override
    public UserInfo getUserInfo(String name) {
        UserInfoImpl userInfo = new UserInfoImpl(name, "");
        int index = this.userInfos.indexOf(userInfo);
        if (index != -1) {
            return this.userInfos.get(index);
        }
        return null;
    }

    public List<UserInfoImpl> getUserInfos() {
        return this.userInfos;
    }

    @Override
    public void load(DataRecord data, RecordTemplate template) {
        String[] fieldNames = template.getFieldNames();
        for (int i = 0; fieldNames != null && i < fieldNames.length; ++i) {
            UserInfoImpl userInfo = new UserInfoImpl(fieldNames[i], "");
            int index = this.userInfos.indexOf(userInfo);
            if (index == -1) continue;
            try {
                Field field = data.getField(fieldNames[i]);
                if (field == null) {
                    SilverLogger.getLogger((Object)this).warn("Cannot get field {0}", new Object[]{fieldNames[i]});
                    continue;
                }
                userInfo = this.userInfos.get(index);
                String value = userInfo.getValue();
                if (value == null) continue;
                field.setStringValue(value);
                continue;
            }
            catch (FormException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
    }
}

