/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.user;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.workflow.api.user.UserSettings;
import org.silverpeas.core.workflow.engine.user.UserInfoImpl;
import org.silverpeas.core.workflow.engine.user.UserSettingsImpl;
import org.silverpeas.core.workflow.engine.user.UserSettingsRepository;
import org.silverpeas.core.workflow.engine.user.UserSettingsService;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Singleton
public class DefaultUserSettingsService
implements UserSettingsService {
    public static final String FIELD_TEXT = "field {0}";
    @Inject
    private UserSettingsRepository repository;
    private static final ConcurrentMap<String, UserSettings> userSettings = new ConcurrentHashMap<String, UserSettings>();

    @Override
    @Transactional
    public void update(UserSettings userSettings, DataRecord data, RecordTemplate template) {
        String[] fieldNames = template.getFieldNames();
        for (int i = 0; fieldNames != null && i < fieldNames.length; ++i) {
            try {
                Field field = data.getField(fieldNames[i]);
                if (field == null) {
                    SilverLogger.getLogger((Object)this).warn(SilverpeasExceptionMessages.failureOnGetting((String)FIELD_TEXT, (Object)fieldNames[i]), new Object[0]);
                    continue;
                }
                String value = field.getStringValue();
                if (value == null) continue;
                this.addUserInfo(userSettings, fieldNames[i], value);
                continue;
            }
            catch (FormException e) {
                SilverLogger.getLogger((Object)this).error(SilverpeasExceptionMessages.failureOnGetting((String)FIELD_TEXT, (Object)data.getId()), (Throwable)e);
            }
        }
        this.repository.save((IdentifiableEntity)((UserSettingsImpl)userSettings));
        this.resetUserSettings(userSettings.getUserId(), userSettings.getComponentId());
    }

    private void addUserInfo(UserSettings userSettings, String name, String value) {
        UserInfoImpl userInfo = new UserInfoImpl(name, value);
        List userInfos = userSettings.getUserInfos();
        int index = userInfos.indexOf(userInfo);
        if (index == -1) {
            userInfo.setUserSettings(userSettings);
            userInfos.add(userInfo);
        } else {
            ((UserInfoImpl)userInfos.get(index)).setValue(value);
        }
    }

    @Override
    public UserSettings get(String userId, String componentId) {
        UserSettings settings = (UserSettings)userSettings.get(userId + "_" + componentId);
        if (settings == null) {
            settings = this.repository.getByUserIdAndComponentId(userId, componentId);
            if (settings == null) {
                settings = new UserSettingsImpl(userId, componentId);
            }
            userSettings.put(userId + "_" + componentId, settings);
        }
        return settings;
    }

    private void resetUserSettings(String userId, String peasId) {
        userSettings.remove(userId + "_" + peasId);
    }
}

