/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.task;

import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.instance.HistoryStep;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.instance.Question;
import org.silverpeas.core.workflow.api.model.Action;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.engine.task.AbstractTaskImpl;

public class TaskImpl
extends AbstractTaskImpl {
    private ProcessInstance processInstance = null;
    private State state = null;
    private HistoryStep[] backSteps = null;
    private Question[] pendingQuestions = null;
    private Question[] relevantQuestions = null;
    private Question[] sentQuestions = null;

    TaskImpl(User user, String roleName, ProcessInstance processInstance, State state) throws WorkflowException {
        super(user, roleName, processInstance.getProcessModel());
        this.processInstance = processInstance;
        this.state = state;
        this.backSteps = null;
    }

    TaskImpl(User user, String roleName, String groupId, ProcessInstance processInstance, State state) throws WorkflowException {
        super(user, roleName, groupId, processInstance.getProcessModel());
        this.processInstance = processInstance;
        this.state = state;
        this.backSteps = null;
    }

    TaskImpl(User user, String roleName, ProcessInstance processInstance, State state, HistoryStep[] backSteps, Question[] sentQuestions, Question[] relevantQuestions, Question[] pendingQuestions) throws WorkflowException {
        super(user, roleName, processInstance.getProcessModel());
        this.processInstance = processInstance;
        this.state = state;
        this.backSteps = backSteps != null ? (HistoryStep[])backSteps.clone() : null;
        this.sentQuestions = sentQuestions != null ? (Question[])sentQuestions.clone() : null;
        this.relevantQuestions = relevantQuestions != null ? (Question[])relevantQuestions.clone() : null;
        this.pendingQuestions = pendingQuestions != null ? (Question[])pendingQuestions.clone() : null;
    }

    @Override
    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    @Override
    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public HistoryStep[] getBackSteps() {
        return this.backSteps;
    }

    @Override
    public Question[] getPendingQuestions() {
        return this.pendingQuestions;
    }

    @Override
    public Question[] getRelevantQuestions() {
        return this.relevantQuestions;
    }

    @Override
    public Question[] getSentQuestions() {
        return this.sentQuestions;
    }

    @Override
    public String[] getActionNames() {
        Action[] actions = this.state.getAllowedActions();
        String[] actionNames = new String[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            actionNames[i] = actions[i].getName();
        }
        return actionNames;
    }
}

