/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.workflow.api.model.Form;
import org.silverpeas.core.workflow.api.model.Forms;
import org.silverpeas.core.workflow.engine.model.FormImpl;

@XmlRootElement(name="forms")
@XmlAccessorType(value=XmlAccessType.NONE)
public class FormsImpl
implements Serializable,
Forms {
    private static final long serialVersionUID = -4621417980509658490L;
    @XmlElement(name="form", type=FormImpl.class)
    private List<Form> formList = new ArrayList<Form>();

    @Override
    public void addForm(Form form) {
        this.formList.add(form);
    }

    @Override
    public Form createForm() {
        return new FormImpl();
    }

    @Override
    public Form getForm(String name) {
        for (Form form : this.formList) {
            if (!form.getName().equals(name)) continue;
            return form;
        }
        return null;
    }

    @Override
    public Form getForm(String name, String role) {
        Form form2Return = null;
        for (Form form : this.formList) {
            if (!name.equals(form.getName()) || (role == null || !role.equalsIgnoreCase(form.getRole())) && (form.getRole() != null || form2Return != null)) continue;
            form2Return = form;
        }
        return form2Return;
    }

    @Override
    public Iterator<Form> iterateForm() {
        return this.formList.iterator();
    }

    @Override
    public void removeForm(String strName, String strRole) {
        Iterator<Form> iter = this.formList.iterator();
        while (iter.hasNext()) {
            Form form = iter.next();
            if (!form.getName().equals(strName) || (strRole != null || form.getRole() != null) && (strRole == null || !strRole.equals(form.getRole()))) continue;
            iter.remove();
            return;
        }
    }
}

