/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.error;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueIntegerIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.workflow.api.Workflow;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.error.WorkflowError;
import org.silverpeas.core.workflow.api.event.GenericEvent;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.model.Action;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.api.user.User;

@Entity
@Table(name="sb_workflow_error")
@NamedQueries(value={@NamedQuery(name="processInstance.findErrors", query="SELECT error FROM WorkflowErrorImpl error WHERE error.instanceId = :id"), @NamedQuery(name="processInstance.deleteErrors", query="DELETE FROM WorkflowErrorImpl error WHERE error.instanceId = :id")})
public class WorkflowErrorImpl
extends BasicJpaEntity<WorkflowErrorImpl, UniqueIntegerIdentifier>
implements WorkflowError {
    @Column
    private int instanceId = -1;
    @Column
    private int stepId;
    @Column
    private String errorMessage = null;
    @Column
    private String stackTrace = null;
    @Column
    private String userId = null;
    @Column
    private String actionName = null;
    @Column
    private Date actionDate = null;
    @Column
    private String userRole = null;
    @Column
    private String stateName = null;
    @Transient
    private transient State state = null;
    @Transient
    private transient ProcessInstance processInstance = null;
    @Transient
    private transient User user = null;
    @Transient
    private transient Action action = null;

    protected WorkflowErrorImpl() {
    }

    public WorkflowErrorImpl(ProcessInstance instance, GenericEvent event, Exception exception) {
        this.processInstance = instance;
        this.instanceId = Integer.parseInt(instance.getInstanceId());
        this.errorMessage = exception.getMessage();
        this.actionName = event.getActionName();
        this.actionDate = event.getActionDate();
        this.userRole = event.getUserRoleName();
        this.user = event.getUser();
        if (this.user != null) {
            this.userId = event.getUser().getUserId();
        }
        this.state = event.getResolvedState();
        if (this.state != null) {
            this.stateName = event.getResolvedState().getName();
        }
        ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(baoStream);
        exception.printStackTrace(printStream);
        this.stackTrace = baoStream.toString().trim();
    }

    @Override
    public ProcessInstance getProcessInstance() throws WorkflowException {
        if (this.processInstance == null && this.instanceId != -1) {
            this.processInstance = Workflow.getProcessInstanceManager().getProcessInstance(String.valueOf(this.instanceId));
        }
        return this.processInstance;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getStackTrace() {
        return this.stackTrace;
    }

    @Override
    public User getUser() throws WorkflowException {
        if (this.user == null && this.userId != null) {
            this.user = Workflow.getUserManager().getUser(this.userId);
        }
        return this.user;
    }

    @Override
    public Action getAction() throws WorkflowException {
        if (this.action == null && this.actionName != null && this.getProcessInstance() != null) {
            this.action = this.getProcessInstance().getProcessModel().getAction(this.actionName);
        }
        return this.action;
    }

    @Override
    public Date getActionDate() {
        return this.actionDate;
    }

    @Override
    public State getResolvedState() throws WorkflowException {
        if (this.state == null && this.stateName != null && this.getProcessInstance() != null) {
            this.state = this.getProcessInstance().getProcessModel().getState(this.stateName);
        }
        return this.state;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

