/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine;

import java.lang.annotation.Annotation;
import org.silverpeas.core.thread.task.AbstractRequestTask;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.event.TaskDoneEvent;
import org.silverpeas.core.workflow.api.instance.UpdatableHistoryStep;
import org.silverpeas.core.workflow.api.instance.UpdatableProcessInstance;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.engine.AbstractRequest;
import org.silverpeas.core.workflow.engine.WorkflowTools;
import org.silverpeas.core.workflow.engine.model.StateImpl;
import org.silverpeas.kernel.logging.SilverLogger;

class TaskDoneRequest
extends AbstractRequest {
    protected TaskDoneRequest() {
    }

    public static TaskDoneRequest get(TaskDoneEvent event) {
        TaskDoneRequest request = (TaskDoneRequest)ServiceProvider.getService(TaskDoneRequest.class, (Annotation[])new Annotation[0]);
        request.setEvent(event);
        return request;
    }

    public void process(AbstractRequestTask.ProcessContext context) throws InterruptedException {
        TaskDoneEvent event = (TaskDoneEvent)this.getEvent();
        UpdatableProcessInstance instance = (UpdatableProcessInstance)event.getProcessInstance();
        String id = instance.getInstanceId();
        UpdatableHistoryStep step = this.fetchHistoryStep(id, event.isResumingAction());
        this.processProcessInstance(id, event, step);
    }

    @Override
    protected boolean processEvent(UpdatableProcessInstance instance, String stepId) throws WorkflowException {
        SilverLogger.getLogger((Object)this).info("processEvent() - instanceId = {0} stepId = {1}", new Object[]{instance.getInstanceId(), stepId});
        TaskDoneEvent event = (TaskDoneEvent)this.getEvent();
        UpdatableHistoryStep step = (UpdatableHistoryStep)instance.getHistoryStep(stepId);
        if (event.isResumingAction()) {
            User eventSubstitute = event.getSubstitute();
            step.setSubstituteId(eventSubstitute != null ? eventSubstitute.getUserId() : null);
            step.setActionDate(event.getActionDate());
        }
        instance.updateHistoryStep(step);
        if (event.getResolvedState() == null) {
            instance.removeWorkingUser(event.getUser(), new StateImpl(""), event.getUserRoleName());
        }
        instance.unLock(event.getResolvedState(), event.getUser());
        if (WorkflowTools.processAction(instance, event, step, true)) {
            return true;
        }
        instance.unLock();
        return false;
    }
}

