/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine;

import java.util.Date;
import javax.inject.Inject;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.thread.task.AbstractRequestTask;
import org.silverpeas.core.workflow.api.ProcessInstanceManager;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.event.GenericEvent;
import org.silverpeas.core.workflow.api.instance.ActionStatus;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.instance.UpdatableHistoryStep;
import org.silverpeas.core.workflow.api.instance.UpdatableProcessInstance;
import org.silverpeas.core.workflow.engine.WorkflowHub;
import org.silverpeas.core.workflow.engine.instance.HistoryStepImpl;
import org.silverpeas.core.workflow.engine.instance.HistoryStepRepository;
import org.silverpeas.core.workflow.engine.instance.ProcessInstanceImpl;
import org.silverpeas.core.workflow.engine.instance.ProcessInstanceManagerImpl;
import org.silverpeas.core.workflow.engine.instance.ProcessInstanceRepository;
import org.silverpeas.kernel.logging.SilverLogger;

public abstract class AbstractRequest
implements AbstractRequestTask.Request<AbstractRequestTask.ProcessContext> {
    @Inject
    private ProcessInstanceRepository repository;
    @Inject
    private HistoryStepRepository historyStepRepository;
    private GenericEvent event;

    protected ProcessInstanceRepository getProcessInstanceRepository() {
        return this.repository;
    }

    protected HistoryStepRepository getHistoryStepRepository() {
        return this.historyStepRepository;
    }

    protected void saveError(UpdatableProcessInstance instance, GenericEvent event, Exception we) {
        WorkflowHub.getErrorManager().saveError(instance, event, we);
        this.setInstanceInError(instance.getInstanceId());
    }

    protected void setInstanceInError(String id) {
        ProcessInstanceImpl processInstance = this.repository.getById(id);
        processInstance.setErrorStatus(true);
        this.repository.save((IdentifiableEntity)processInstance);
    }

    protected UpdatableHistoryStep createHistoryNewStep(HistoryStepDescriptor descriptor) {
        ProcessInstanceManager instanceManager = WorkflowHub.getProcessInstanceManager();
        SilverLogger.getLogger((Object)this).info("createHistoryNewStep() - InstanceId = {0}", new Object[]{descriptor.getProcessInstance().getInstanceId()});
        UpdatableHistoryStep newStep = (UpdatableHistoryStep)instanceManager.createHistoryStep();
        if (this.event.getUser() != null) {
            newStep.setUserId(this.event.getUser().getUserId());
        }
        if (this.event.getSubstitute() != null) {
            newStep.setSubstituteId(this.event.getSubstitute().getUserId());
        }
        SilverLogger.getLogger((Object)this).info("createHistoryNewStep() - ActionName = {0}", new Object[]{descriptor.getActionName()});
        newStep.setAction(descriptor.getActionName());
        newStep.setActionDate(descriptor.getActionDate());
        newStep.setUserRoleName(descriptor.getUserRoleName());
        if (this.event.getResolvedState() != null) {
            newStep.setResolvedState(this.event.getResolvedState().getName());
        }
        newStep.setActionStatus(ActionStatus.TO_BE_PROCESSED);
        newStep.setProcessInstance(descriptor.getProcessInstance());
        this.getHistoryStepRepository().save((IdentifiableEntity)((HistoryStepImpl)newStep));
        return newStep;
    }

    protected UpdatableHistoryStep fetchHistoryStep(String processInstanceId, boolean existingStep) {
        return (UpdatableHistoryStep)Transaction.performInOne(() -> {
            ProcessInstanceImpl processInstance = this.getProcessInstanceRepository().getById(processInstanceId);
            if (existingStep) {
                return (UpdatableHistoryStep)processInstance.getSavedStep(this.event.getUser().getUserId());
            }
            return this.createHistoryNewStep(new HistoryStepDescriptor().withProcessInstance(processInstance));
        });
    }

    protected void processProcessInstance(String id, GenericEvent event, UpdatableHistoryStep step) {
        SilverLogger.getLogger((Object)this).info("processProcessInstance() - instanceId = {0}", new Object[]{id});
        Transaction.performInOne(() -> {
            ProcessInstanceManager instanceManager = WorkflowHub.getProcessInstanceManager();
            ProcessInstanceImpl processInstance = this.getProcessInstanceRepository().getById(id);
            try {
                boolean removeInstance = this.processEvent(processInstance, step.getId());
                if (removeInstance) {
                    ((ProcessInstanceManagerImpl)instanceManager).removeProcessInstance(id);
                } else {
                    this.getProcessInstanceRepository().save((IdentifiableEntity)processInstance);
                }
            }
            catch (WorkflowException we) {
                this.saveError(processInstance, event, (Exception)((Object)we));
                throw new WorkflowException("WorkflowEngineThread.process", we.getMessage(), (Exception)((Object)we));
            }
            return null;
        });
    }

    protected abstract boolean processEvent(UpdatableProcessInstance var1, String var2) throws WorkflowException;

    void setEvent(GenericEvent event) {
        this.event = event;
    }

    <T extends GenericEvent> T getEvent() {
        return (T)this.event;
    }

    protected class HistoryStepDescriptor {
        private ProcessInstance processInstance;
        private String actionName;
        private Date actionDate;
        private String userRoleName;

        protected HistoryStepDescriptor() {
        }

        public ProcessInstance getProcessInstance() {
            return this.processInstance;
        }

        public HistoryStepDescriptor withProcessInstance(ProcessInstance processInstance) {
            this.processInstance = processInstance;
            return this;
        }

        public String getActionName() {
            return this.actionName == null ? AbstractRequest.this.event.getActionName() : this.actionName;
        }

        public HistoryStepDescriptor withActionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public String getUserRoleName() {
            return this.userRoleName == null ? AbstractRequest.this.event.getUserRoleName() : this.userRoleName;
        }

        public HistoryStepDescriptor withUserRoleName(String userRoleName) {
            this.userRoleName = userRoleName;
            return this;
        }

        public Date getActionDate() {
            return this.actionDate == null ? AbstractRequest.this.event.getActionDate() : this.actionDate;
        }

        public HistoryStepDescriptor withActionDate(Date actionDate) {
            this.actionDate = actionDate;
            return this;
        }
    }
}

