/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.server.rest;

import edu.psu.swe.scim.server.schema.Registry;
import edu.psu.swe.scim.spec.protocol.ResourceTypesResource;
import edu.psu.swe.scim.spec.protocol.data.ListResponse;
import edu.psu.swe.scim.spec.schema.Meta;
import edu.psu.swe.scim.spec.schema.ResourceType;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Stateless
public class ResourceTypesResourceImpl
implements ResourceTypesResource {
    @Inject
    private Registry registry;
    @Context
    private UriInfo uriInfo;

    public Response getAllResourceTypes(String filter) {
        if (filter != null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Collection<ResourceType> resourceTypes = this.registry.getAllResourceTypes();
        for (ResourceType resourceType : resourceTypes) {
            Meta meta = new Meta();
            meta.setLocation(this.uriInfo.getAbsolutePathBuilder().path(resourceType.getName()).build(new Object[0]).toString());
            meta.setResourceType(resourceType.getResourceType());
            resourceType.setMeta(meta);
        }
        ListResponse listResponse = new ListResponse();
        listResponse.setItemsPerPage(Integer.valueOf(resourceTypes.size()));
        listResponse.setStartIndex(Integer.valueOf(1));
        listResponse.setTotalResults(resourceTypes.size());
        ArrayList<ResourceType> objectList = new ArrayList<ResourceType>(resourceTypes);
        listResponse.setResources(objectList);
        return Response.ok((Object)listResponse).build();
    }

    public Response getResourceType(String name) {
        ResourceType resourceType = this.registry.getResourceType(name);
        if (resourceType == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Meta meta = new Meta();
        meta.setLocation(this.uriInfo.getAbsolutePath().toString());
        meta.setResourceType(resourceType.getResourceType());
        resourceType.setMeta(meta);
        return Response.ok((Object)resourceType).build();
    }
}

