/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.test;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.jcetaglib.lib.Macs;
import net.sourceforge.jcetaglib.test.RunTest;

public class MacTest
extends TestCase {
    private StringBuffer mac1 = null;
    private StringBuffer mac2 = null;

    protected void setUp() throws IOException {
        FileOutputStream outStr = new FileOutputStream("C:/tmp/readable.txt");
        DataOutputStream dataStr = new DataOutputStream(outStr);
        dataStr.writeBytes("This is a readable string inside a file");
        dataStr.flush();
        dataStr.close();
        outStr.close();
    }

    public void testMac() throws Exception {
        for (int i = 0; i < RunTest.macalg.length; ++i) {
            for (int j = 0; j < RunTest.text.length; ++j) {
                this.mac1 = Macs.generateMAC(RunTest.text[j], "C:/tmp/" + RunTest.macalg[i][1], new StringBuffer("password"), RunTest.alg[i][0], RunTest.macalg[i][0]);
                this.mac2 = Macs.generateMAC(RunTest.text[j], "C:/tmp/" + RunTest.macalg[i][1], new StringBuffer("password"), RunTest.alg[i][0], RunTest.macalg[i][0]);
                Assert.assertEquals((String)this.mac1.toString(), (String)this.mac2.toString());
            }
        }
    }

    public void testFileMac() throws Exception {
        for (int i = 0; i < RunTest.macalg.length; ++i) {
            this.mac1 = Macs.generateFileMAC("C:/tmp/readable.txt", "C:/tmp/" + RunTest.macalg[i][1], new StringBuffer("password"), RunTest.alg[i][0], RunTest.macalg[i][0]);
            this.mac2 = Macs.generateFileMAC("C:/tmp/readable.txt", "C:/tmp/" + RunTest.macalg[i][1], new StringBuffer("password"), RunTest.alg[i][0], RunTest.macalg[i][0]);
            Assert.assertEquals((String)this.mac1.toString(), (String)this.mac2.toString());
        }
    }
}

