/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.variables;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.model.identifier.UuidIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.SilverpeasJpaEntity;
import org.silverpeas.core.security.Securable;
import org.silverpeas.core.variables.VariableScheduledValue;
import org.silverpeas.core.variables.VariableValueSet;
import org.silverpeas.core.variables.VariablesRepository;

@Entity
@Table(name="sb_variables_variable")
@NamedQueries(value={@NamedQuery(name="allVariables", query="select v from Variable v order by v.label ASC"), @NamedQuery(name="currentVariables", query="select distinct v from Variable v join v.values vv where vv.startDate <= :today and :today <= vv.endDate order by v.label ASC")})
public class Variable
extends SilverpeasJpaEntity<Variable, UuidIdentifier>
implements Securable {
    @Column(nullable=false)
    private String label;
    @Column(nullable=false)
    private String description;
    @OneToMany(mappedBy="variable", fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    private final Set<VariableScheduledValue> values = new HashSet<VariableScheduledValue>();

    protected Variable() {
    }

    public Variable(String label, String description) {
        this.label = label;
        this.description = description;
    }

    public static Variable getById(String id) {
        return (Variable)VariablesRepository.get().getById(id);
    }

    public static List<Variable> getAll() {
        return VariablesRepository.get().getAllVariables();
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public VariableValueSet getVariableValues() {
        return new VariableValueSet(this);
    }

    public int getNumberOfValues() {
        return this.values().size();
    }

    public void merge(Variable variable) {
        this.setLabel(variable.getLabel());
        this.setDescription(variable.getDescription());
    }

    public Variable save() {
        return Transaction.performInOne(() -> VariablesRepository.get().save(this));
    }

    public void delete() {
        Transaction.performInOne(() -> {
            VariablesRepository.get().delete(new Variable[]{this});
            return null;
        });
    }

    @Override
    public boolean canBeAccessedBy(User user) {
        return true;
    }

    @Override
    public boolean canBeModifiedBy(User user) {
        return user.isAccessAdmin();
    }

    @Override
    public boolean canBeDeletedBy(User user) {
        return user.isAccessAdmin();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    Set<VariableScheduledValue> values() {
        return this.values;
    }
}

