/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.time;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.silverpeas.core.date.TimeUnit;
import org.silverpeas.core.util.UnitUtil;
import org.silverpeas.core.util.time.DurationUnit;

public class Duration {
    private static final List<TimeUnit> orderedUnits = new ArrayList<TimeUnit>(EnumSet.allOf(TimeUnit.class));
    private static final BigDecimal ONE = new BigDecimal("1");
    private final BigDecimal time;

    public Duration(long time) {
        this.time = new BigDecimal(String.valueOf(time));
    }

    public Duration(BigDecimal time) {
        this.time = time;
    }

    private static DurationUnit d(TimeUnit timeUnit) {
        return DurationUnit.from(timeUnit);
    }

    public static BigDecimal convertTo(BigDecimal value, TimeUnit from, TimeUnit to) {
        int toIndex;
        int fromIndex = orderedUnits.indexOf(from);
        int offsetIndex = fromIndex - (toIndex = orderedUnits.indexOf(to));
        if (offsetIndex > 0) {
            return value.multiply(Duration.d(from).getMultiplier(Duration.d(to))).setScale(15, 1);
        }
        if (offsetIndex < 0) {
            return value.divide(Duration.d(from).getMultiplier(Duration.d(to)), 15, 1);
        }
        return value;
    }

    public BigDecimal getTime() {
        return this.getTimeConverted(TimeUnit.MILLISECOND);
    }

    public Long getTimeAsLong() {
        return this.getTimeConverted(TimeUnit.MILLISECOND).longValue();
    }

    public BigDecimal getRoundedTimeConverted(TimeUnit to) {
        BigDecimal convertedSize = this.getTimeConverted(to);
        int nbMaximumFractionDigits = 2;
        if (TimeUnit.MILLISECOND == to || TimeUnit.SECOND == to) {
            nbMaximumFractionDigits = 3;
        }
        return convertedSize.setScale(nbMaximumFractionDigits, 1);
    }

    public BigDecimal getTimeConverted(TimeUnit to) {
        return Duration.convertTo(this.time, TimeUnit.MILLISECOND, to);
    }

    public TimeUnit getBestUnit() {
        for (int i = 1; i < orderedUnits.size(); ++i) {
            TimeUnit nextUnit = orderedUnits.get(i);
            TimeUnit currentUnit = orderedUnits.get(i - 1);
            BigDecimal nextUnitLimit = Duration.convertTo(ONE, nextUnit, TimeUnit.MILLISECOND);
            if (this.time.compareTo(nextUnitLimit) >= 0) continue;
            return currentUnit;
        }
        return orderedUnits.get(orderedUnits.size() - 1);
    }

    public BigDecimal getBestValue() {
        TimeUnit bestUnit = this.getBestUnit();
        return this.getRoundedTimeConverted(bestUnit);
    }

    private String getBestDisplayValue(boolean valueOnly) {
        return this.getFormattedValue(this.getBestUnit(), valueOnly);
    }

    public String getBestDisplayValueOnly() {
        return this.getBestDisplayValue(true);
    }

    public String getBestDisplayValue() {
        return this.getBestDisplayValue(false);
    }

    private String getFormattedValue(TimeUnit to, boolean valueOnly) {
        BigDecimal bestDisplayValue = this.getRoundedTimeConverted(to);
        StringBuilder sb = new StringBuilder();
        sb.append(new DecimalFormat().format(bestDisplayValue));
        if (!valueOnly) {
            sb.append(" ");
            sb.append(Duration.d(to).getLabel());
        }
        return sb.toString();
    }

    public String getFormattedValueOnly(TimeUnit to) {
        return this.getFormattedValue(to, true);
    }

    public String getFormattedValue(TimeUnit to) {
        return this.getFormattedValue(to, false);
    }

    public String getFormattedDurationAsHMSM() {
        return this.getFormattedDuration("HH:mm:ss.SSS");
    }

    public String getFormattedDurationAsHMS() {
        Duration roundedDuration = UnitUtil.getDuration(this.getRoundedTimeConverted(TimeUnit.SECOND).setScale(0, 5), TimeUnit.SECOND);
        return roundedDuration.getFormattedDuration("HH:mm:ss");
    }

    public String getFormattedDuration(String format) {
        return DurationFormatUtils.formatDuration((long)this.getTimeAsLong(), (String)format);
    }
}

