/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.ui;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

public class DisplayI18NHelper {
    private static final String ZONE_ID_COMPOSED_WITH_LETTERS_ONLY = "(?i)^[a-z_]+/[a-z_]+";
    private static List<String> languages;
    private static String defaultLanguage;
    private static List<String> zoneIds;
    private static ZoneId defaultZoneId;

    private DisplayI18NHelper() {
    }

    public static String getDefaultLanguage() {
        return defaultLanguage;
    }

    public static ZoneId getDefaultZoneId() {
        return defaultZoneId;
    }

    public static List<String> getLanguages() {
        return Collections.unmodifiableList(languages);
    }

    public static List<String> getZoneIds() {
        return Collections.unmodifiableList(zoneIds);
    }

    public static String verifyLanguage(String language) {
        if (languages.contains(language)) {
            return language;
        }
        return DisplayI18NHelper.getDefaultLanguage();
    }

    public static ZoneId verifyZoneId(String zoneId) {
        if (zoneIds.contains(zoneId)) {
            return ZoneId.of(zoneId);
        }
        return DisplayI18NHelper.getDefaultZoneId();
    }

    static {
        String[] supportedLanguages;
        languages = new ArrayList<String>();
        zoneIds = new ArrayList<String>();
        SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.personalization.settings.personalizationPeasSettings");
        defaultLanguage = settings.getString("DefaultLanguage");
        defaultZoneId = ZoneId.of(settings.getString("DefaultZoneId"));
        for (String lang : supportedLanguages = settings.getString("languages").split(",")) {
            if ((lang = lang.trim()).isEmpty()) continue;
            languages.add(lang);
        }
        ZoneId.getAvailableZoneIds().stream().filter(s -> s.matches(ZONE_ID_COMPOSED_WITH_LETTERS_ONLY)).sorted().forEach(s -> zoneIds.add((String)s));
    }
}

