/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.template;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.template.renderer.DateRenderer;
import org.silverpeas.core.template.renderer.StringRenderer;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupDir;
import org.stringtemplate.v4.STRawGroupDir;
import org.stringtemplate.v4.STWriter;

public class SilverpeasStringTemplate
implements SilverpeasTemplate {
    private static final Object MUTEX = new Object();
    private static final String MERGED_DIR_NAME = "__merged_delete_me_on_template_modification";
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Properties templateConfig;
    private final List<String> paths = new ArrayList<String>(3);
    private final TriFunction<String, Charset, Character, STGroup> getRawGroupDir = (templateDir, charset, token) -> new STRawGroupDir(templateDir, charset.name(), token.charValue(), token.charValue());
    private final TriFunction<String, Charset, Character, STGroup> getGroupDir = (templateDir, charset, token) -> new STGroupDir(templateDir, charset.name(), token.charValue(), token.charValue());

    public SilverpeasStringTemplate(Properties templateConfig) {
        this.templateConfig = templateConfig;
        this.paths.add(templateConfig.getProperty("template.customer.dir"));
        this.paths.add(templateConfig.getProperty("template.root.dir"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SilverpeasTemplate mergeRootWithCustom() {
        if (this.paths.size() == 2) {
            File customPath = new File(this.paths.get(0));
            if (!customPath.exists()) {
                return this;
            }
            File rootPath = new File(this.paths.get(1));
            File mergedPath = new File(customPath, MERGED_DIR_NAME);
            Object object = MUTEX;
            synchronized (object) {
                if (!mergedPath.exists()) {
                    if (mergedPath.mkdirs()) {
                        try {
                            FileUtils.copyDirectory((File)rootPath, (File)mergedPath, (boolean)true);
                            FileUtils.copyDirectory((File)customPath, (File)mergedPath, f -> !MERGED_DIR_NAME.equals(f.getName()), (boolean)true);
                            this.paths.add(0, mergedPath.getPath());
                        }
                        catch (IOException e) {
                            SilverLogger.getLogger((Object)this).error((Throwable)e);
                        }
                    }
                } else {
                    this.paths.add(0, mergedPath.getPath());
                }
            }
        }
        return this;
    }

    @Override
    public String applyFileTemplate(String fileName) {
        return this.applyTemplate(fileName, this.getRawGroupDir);
    }

    @Override
    public String applyFileTemplateDescriptor(String descriptor) {
        return this.applyTemplate(descriptor, this.getGroupDir);
    }

    @Override
    public String applyStringTemplate(String template) {
        ST compiledTemplate = new ST(template, '$', '$');
        return this.applyAttributes(compiledTemplate);
    }

    protected String applyAttributes(ST template) {
        String string;
        for (Map.Entry<String, Object> attribute : this.attributes.entrySet()) {
            template.add(attribute.getKey(), attribute.getValue());
        }
        StringWriter writer = new StringWriter();
        try {
            AutoIndentWriter out = new AutoIndentWriter((Writer)writer);
            template.write((STWriter)out);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return template.toString();
            }
        }
        writer.close();
        return string;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (value instanceof String && StringUtil.isNotDefined((String)((String)value))) {
            value = null;
        }
        this.attributes.put(name, value);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public String applyFileTemplateOnComponent(String componentName, String fileName) {
        return this.applyFileTemplate("/" + componentName.toLowerCase() + "/" + fileName);
    }

    @Override
    public boolean isCustomTemplateExists(String componentName, String fileName) {
        String customersRootDir = this.templateConfig.getProperty("template.customer.dir");
        return this.isTemplateFileExist(Path.of(customersRootDir, componentName.toLowerCase()), fileName);
    }

    private String applyTemplate(String fileName, TriFunction<String, Charset, Character, STGroup> groupGetter) {
        return this.paths.stream().filter(p -> Files.isDirectory(Path.of(p, new String[0]), new LinkOption[0])).map(p -> {
            STGroup g = (STGroup)groupGetter.apply((String)p, Charsets.UTF_8, Character.valueOf('$'));
            g.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
            g.registerRenderer(Date.class, (AttributeRenderer)new DateRenderer());
            return g;
        }).map(g -> g.getInstanceOf(fileName)).filter(Objects::nonNull).findFirst().map(this::applyAttributes).orElse("");
    }

    private boolean isTemplateFileExist(Path rootDir, String fileName) {
        Object f = fileName.toLowerCase().endsWith(".st") ? fileName : fileName + ".st";
        return Files.isRegularFile(rootDir.resolve((String)f), new LinkOption[0]);
    }

    @FunctionalInterface
    private static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

