/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.token.persistent;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.silverpeas.core.persistence.EntityReference;
import org.silverpeas.core.persistence.ResourceBelonging;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueLongIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.security.token.Token;
import org.silverpeas.core.security.token.annotation.TokenGenerator;
import org.silverpeas.core.security.token.exception.TokenException;
import org.silverpeas.core.security.token.exception.TokenValidationException;
import org.silverpeas.core.security.token.persistent.PersistentResourceTokenGenerator;
import org.silverpeas.core.security.token.persistent.service.PersistentResourceTokenService;
import org.silverpeas.kernel.util.StringUtil;

@Entity
@Table(name="st_token")
@TokenGenerator(value=PersistentResourceTokenGenerator.class)
@NamedQueries(value={@NamedQuery(name="PersistentResourceToken.getByTypeAndResourceId", query="select p from PersistentResourceToken p where p.resourceType = :type and p.resourceId = :resourceId"), @NamedQuery(name="PersistentResourceToken.getByToken", query="select p from PersistentResourceToken p where p.value = :token")})
public class PersistentResourceToken
extends BasicJpaEntity<PersistentResourceToken, UniqueLongIdentifier>
implements Token,
ResourceBelonging {
    private static final long serialVersionUID = 5956074363457906409L;
    public static final PersistentResourceToken NoneToken = new PersistentResourceToken();
    @Column(name="tokenType", nullable=false)
    private String resourceType = "UNKNOWN";
    @Column(name="resourceId", nullable=false)
    private String resourceId;
    @Column(name="token", nullable=false)
    private String value;
    @Column(name="saveCount", nullable=false)
    private int saveCount = 0;
    @Column(name="saveDate", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date saveDate;

    protected PersistentResourceToken() {
    }

    protected PersistentResourceToken(EntityReference<?> resource, String value) {
        this.value = value;
        this.resourceId = resource.getId();
        this.resourceType = resource.getType();
    }

    public static PersistentResourceToken getOrCreateToken(EntityReference<?> resource) throws TokenException {
        PersistentResourceTokenService service = PersistentResourceTokenService.get();
        PersistentResourceToken token = service.get(resource);
        if (!token.isDefined()) {
            token = service.initialize(resource);
        }
        return token;
    }

    public static PersistentResourceToken getToken(String token) {
        PersistentResourceTokenService service = PersistentResourceTokenService.get();
        return service.get(token);
    }

    public static void removeToken(EntityReference<?> resource) {
        PersistentResourceTokenService service = PersistentResourceTokenService.get();
        service.remove(resource);
    }

    @Override
    protected void performBeforePersist() {
        super.performBeforePersist();
        this.performSaveDate();
    }

    @Override
    protected void performBeforeUpdate() {
        super.performBeforeUpdate();
        this.performSaveDate();
    }

    private void performSaveDate() {
        this.setSaveCount(this.getSaveCount() + 1);
        this.setSaveDate(new Date());
    }

    public boolean exists() {
        return this.getId() != null;
    }

    public boolean notExists() {
        return this.getId() == null;
    }

    public void validate() throws TokenValidationException {
        if (this.resourceType == null || "UNKNOWN".equals(this.resourceType) || !StringUtil.isDefined((String)this.resourceId)) {
            throw new TokenValidationException("The token isn't valid! Missing resource reference");
        }
    }

    public void setId(Long id) {
        this.setId(String.valueOf(id));
    }

    public void setResource(EntityReference<?> resource) {
        if (resource != null) {
            this.resourceType = resource.getType();
            this.resourceId = resource.getId();
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getSaveCount() {
        return this.saveCount;
    }

    public void setSaveCount(int saveCount) {
        this.saveCount = saveCount;
    }

    public Date getSaveDate() {
        return this.saveDate;
    }

    public void setSaveDate(Date saveDate) {
        this.saveDate = saveDate;
    }

    public String toString() {
        return "PersistentResourceToken{resourceType='" + this.resourceType + "', resourceId='" + this.resourceId + "', value='" + this.value + "'}";
    }

    @Override
    public boolean isDefined() {
        return this.exists() && this != NoneToken;
    }

    @Override
    public String getResourceType() {
        return this.resourceType;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }
}

