/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.kernel.annotation.Defined;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class AuthenticationCredential {
    private final SettingBundle authenticationSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.authentication.settings.authenticationSettings");
    private final Map<String, Serializable> capabilities = new HashMap<String, Serializable>();
    private String login;
    private String password;
    private String domainId;
    private boolean authenticated;

    private AuthenticationCredential() {
    }

    public static AuthenticationCredential newWithAsLogin(@Defined String login) throws AuthenticationException {
        StringUtil.requireDefined((String)login, () -> new AuthenticationException("The user login isn't defined!", new String[0]));
        AuthenticationCredential credential = new AuthenticationCredential();
        credential.setLogin(login);
        return credential;
    }

    public AuthenticationCredential withAsPassword(String password) {
        this.setPassword(password);
        return this;
    }

    public AuthenticationCredential withAsDomainId(String domainId) {
        this.setDomainId(domainId);
        return this;
    }

    public void setRemotelyAuthenticated() {
        this.authenticated = true;
    }

    @Defined
    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public Map<String, Serializable> getCapabilities() {
        return this.capabilities;
    }

    public boolean loginIgnoreCase() {
        return Optional.ofNullable(this.getDomainId()).filter(StringUtil::isDefined).map(d -> this.authenticationSettings.getString("loginIgnoreCaseOnUserAuthentication.domain" + d, null)).filter(StringUtil::isDefined).map(StringUtil::getBooleanValue).orElseGet(() -> this.authenticationSettings.getBoolean("loginIgnoreCaseOnUserAuthentication.default", false));
    }

    private void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public boolean hasBeenRemotelyAuthenticated() {
        return this.authenticated;
    }
}

