/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.Mutable;

public class LongText {
    private static final int PART_SIZE_MAX = 1998;
    private static final String INSERT_LONG_TEXT = "insert into ST_LongText (id, orderNum, bodyContent) values (?, ?, ?)";

    private LongText() {
    }

    public static int addLongText(String theText) throws SQLException {
        int theId = DBUtil.getNextId("ST_LongText", "id");
        int orderNum = 0;
        try (Connection connection = DBUtil.openConnection();
             PreparedStatement stmt = connection.prepareStatement(INSERT_LONG_TEXT);){
            if (theText == null || theText.length() <= 0) {
                int i = 1;
                stmt.setInt(i++, theId);
                stmt.setInt(i++, orderNum);
                stmt.setString(i, "");
                stmt.executeUpdate();
            } else {
                while (orderNum * 1998 < theText.length()) {
                    String partText = (orderNum + 1) * 1998 < theText.length() ? theText.substring(orderNum * 1998, (orderNum + 1) * 1998) : theText.substring(orderNum * 1998);
                    int i = 1;
                    stmt.setInt(i++, theId);
                    stmt.setInt(i++, orderNum);
                    stmt.setString(i, partText);
                    stmt.executeUpdate();
                    ++orderNum;
                }
            }
        }
        return theId;
    }

    public static String getLongText(int longTextId) {
        try {
            StringBuilder content = new StringBuilder();
            JdbcSqlQuery.select("bodyContent from ST_LongText").where("id = ?", longTextId).addSqlPart("order by orderNum", new Object[0]).executeUnique(row -> {
                content.append(row.getString(1));
                return null;
            });
            return content.toString();
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    public static Map<Integer, String> listLongTexts(Collection<Integer> longTextIds) {
        try {
            boolean idIndex = true;
            int contentIndex = 2;
            Mutable previousId = Mutable.empty();
            StringBuilder content = new StringBuilder();
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            JdbcSqlQuery.select("id, bodyContent from ST_LongText").where("id", new Object[0]).in(longTextIds).addSqlPart("order by id, orderNum", new Object[0]).execute(row -> {
                int id = row.getInt(1);
                previousId.filter(i -> i != id).ifPresent(i -> {
                    result.put((Integer)i, content.toString());
                    content.setLength(0);
                });
                previousId.set((Object)id);
                content.append(row.getString(2));
                return null;
            });
            previousId.ifPresent(i -> result.put((Integer)i, content.toString()));
            return result;
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    public static void removeLongText(int longTextId) {
        try {
            JdbcSqlQuery.deleteFrom("ST_LongText").where("id = ?", longTextId).execute();
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }
}

