/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.datasource.model.jpa;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.persistence.AttributeOverride;
import javax.persistence.EmbeddedId;
import javax.persistence.EntityManager;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.core.persistence.datasource.model.EntityIdentifier;
import org.silverpeas.core.persistence.datasource.model.ExternalEntityIdentifier;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.persistence.datasource.model.jpa.EntityManagerProvider;
import org.silverpeas.core.util.annotation.ClassAnnotationUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@MappedSuperclass
public abstract class AbstractJpaEntity<T extends IdentifiableEntity, U extends EntityIdentifier>
implements IdentifiableEntity {
    @EmbeddedId
    private U id;

    @Override
    public String getId() {
        return this.id == null ? null : this.id.asString();
    }

    @Override
    public boolean isPersisted() {
        if (this.id != null) {
            EntityManager entityManager = EntityManagerProvider.get().getEntityManager();
            return entityManager.find(this.getClass(), this.id) != null;
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder hash = new HashCodeBuilder();
        hash.append(this.getId() != null ? this.getId() : Integer.valueOf(super.hashCode()));
        return hash.toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (super.equals(obj)) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentifiableEntity other = (IdentifiableEntity)obj;
        if (this.getId() != null && other.getId() != null) {
            EqualsBuilder matcher = new EqualsBuilder();
            matcher.append((Object)this.getId(), (Object)other.getId());
            return matcher.isEquals();
        }
        return false;
    }

    protected U getNativeId() {
        return this.id;
    }

    protected T setId(String id) {
        if (StringUtil.isDefined((String)id)) {
            try {
                this.id = this.newIdentifierInstance();
                this.id.fromString(id);
            }
            catch (Exception e) {
                throw new SilverpeasRuntimeException((Throwable)e);
            }
        } else {
            this.id = null;
        }
        return (T)this;
    }

    protected abstract void performBeforePersist();

    protected abstract void performBeforeUpdate();

    protected abstract void performBeforeRemove();

    private U newIdentifierInstance() {
        try {
            return (U)((EntityIdentifier)this.getEntityIdentifierClass().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    @PrePersist
    private void beforePersist() {
        boolean isExternalIdentifier = ExternalEntityIdentifier.class.isAssignableFrom(this.getEntityIdentifierClass());
        if (!isExternalIdentifier) {
            if (this.id != null && StringUtil.isDefined((String)this.id.asString())) {
                SilverLogger.getLogger((Object)this).warn("As the entity identifier is not a ForeignEntityIdentifier one, identifier value should not exist on a persist operation... (ID=" + this.getId() + ")", new Object[0]);
            }
            Class classThatDeclaresTable = ClassAnnotationUtil.searchClassThatDeclaresAnnotation(Table.class, this.getClass());
            String tableName = classThatDeclaresTable.getAnnotation(Table.class).name();
            String primaryKey = "id";
            AttributeOverride attributeOverride = classThatDeclaresTable.getAnnotation(AttributeOverride.class);
            if (attributeOverride != null && primaryKey.equals(attributeOverride.name())) {
                primaryKey = attributeOverride.column().name();
            }
            this.id = this.newIdentifierInstance().generateNewId(tableName, primaryKey);
        }
        this.performBeforePersist();
    }

    @PreUpdate
    private void beforeUpdate() {
        this.performBeforeUpdate();
    }

    @PreRemove
    private void beforeRemove() {
        this.performBeforeRemove();
    }

    private Class<U> getEntityIdentifierClass() {
        Type parent = this.getClass().getGenericSuperclass();
        while (!(parent instanceof ParameterizedType)) {
            parent = this.getClass().getSuperclass().getGenericSuperclass();
        }
        return (Class)((ParameterizedType)parent).getActualTypeArguments()[1];
    }
}

