/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.message;

import java.text.MessageFormat;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Optional;
import org.owasp.encoder.Encode;
import org.silverpeas.core.notification.message.Message;
import org.silverpeas.core.notification.message.MessageManager;
import org.silverpeas.kernel.bundle.LocalizationBundle;

public class MessageNotifier {
    private MessageNotifier() {
    }

    public static LocalizationBundle getLocalizationBundle(String bundleBaseName) {
        return MessageManager.getLocalizationBundle(bundleBaseName);
    }

    public static Message addSevere(String message, Object ... parameters) {
        return MessageManager.addSevere(MessageNotifier.format(message, parameters));
    }

    public static Message addError(String message, Object ... parameters) {
        return MessageManager.addError(MessageNotifier.format(message, parameters));
    }

    public static Message addWarning(String message, Object ... parameters) {
        return MessageManager.addWarning(MessageNotifier.format(message, parameters));
    }

    public static Message addSuccess(String message, Object ... parameters) {
        return MessageManager.addSuccess(MessageNotifier.format(message, parameters));
    }

    public static Message addInfo(String message, Object ... parameters) {
        return MessageManager.addInfo(MessageNotifier.format(message, parameters));
    }

    public static String formatDate(Temporal temporal) {
        return "${" + temporal.toString() + ",date}";
    }

    public static String formatDateTime(Temporal temporal) {
        return "${" + temporal.toString() + ",datetime}";
    }

    private static String format(String message, Object ... parameters) {
        if (parameters.length != 0) {
            return MessageFormat.format(message, Arrays.stream(parameters).map(p -> Optional.of(p).filter(String.class::isInstance).map(String.class::cast).map(Encode::forHtml).map(Object.class::cast).orElse(p)).toArray());
        }
        return message;
    }
}

