/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.ddwe;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.kernel.util.StringUtil;

public class DragAndDropEditorContent {
    final String content;
    final Map<String, String> json;

    public DragAndDropEditorContent(String content) {
        this.content = StringUtil.defaultStringIfNotDefined((String)content);
        this.json = this.getSimpleContent().isPresent() ? new HashMap<String, String>() : Optional.ofNullable(content).filter(StringUtil::isDefined).map(f -> JSONCodec.decode(f, Map.class)).orElseGet(HashMap::new);
    }

    public Optional<String> getSimpleContent() {
        return Optional.of(this.content).filter(StringUtil::isDefined).filter(Predicate.not(c -> c.startsWith("{")));
    }

    public void setTemporaryInlinedHtml(String html) {
        this.json.put("gjs-tmp-inlinedHtml", StringUtil.defaultStringIfNotDefined((String)html));
    }

    public String getInlinedHtml() {
        return this.getSimpleContent().orElseGet(() -> this.json.getOrDefault("gjs-inlinedHtml", ""));
    }

    public String getEncodedJson() {
        return JSONCodec.encode(this.json);
    }

    public String getInitialRawContent() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DragAndDropEditorContent that = (DragAndDropEditorContent)o;
        return this.content.equals(that.content) && this.json.equals(that.json);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.json);
    }
}

