/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.persistence.datasource.model.identifier.UuidIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.SilverpeasJpaEntity;
import org.silverpeas.kernel.SilverpeasRuntimeException;

@Entity
@Table(name="sb_cal_attendees")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="type", discriminatorType=DiscriminatorType.INTEGER)
public abstract class Attendee
extends SilverpeasJpaEntity<Attendee, UuidIdentifier> {
    @Column(nullable=false)
    private String attendeeId;
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @JoinColumn(name="componentId", referencedColumnName="id", nullable=false)
    private CalendarComponent component;
    @OneToOne
    @JoinColumn(name="delegate", referencedColumnName="id")
    private Attendee delegate;
    @Column(name="participation", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ParticipationStatus participationStatus = ParticipationStatus.AWAITING;
    @Column(name="presence", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private PresenceStatus presenceStatus = PresenceStatus.REQUIRED;
    @Transient
    private boolean presenceStatusChanged = false;
    @Transient
    private boolean participationStatusAnswered = false;

    protected Attendee() {
    }

    protected Attendee(String id, CalendarComponent component) {
        this.attendeeId = id;
        this.component = component;
    }

    @Override
    public String getId() {
        return this.attendeeId;
    }

    public abstract String getFullName();

    public CalendarComponent getCalendarComponent() {
        return this.component;
    }

    public ParticipationStatus getParticipationStatus() {
        return this.participationStatus;
    }

    public Optional<Attendee> getDelegate() {
        return Optional.ofNullable(this.delegate);
    }

    public void delegateTo(AttendeeSupplier anotherAttendee) {
        this.participationStatusAnswered = this.participationStatus != ParticipationStatus.DELEGATED;
        this.participationStatus = ParticipationStatus.DELEGATED;
        this.delegate = anotherAttendee.to(this.component).withPresenceStatus(this.presenceStatus);
        this.delegate.delegate = this;
        this.component.getAttendees().add(this.delegate);
    }

    void setParticipationStatus(ParticipationStatus participationStatus) {
        this.participationStatusAnswered = this.participationStatus != participationStatus;
        this.participationStatus = participationStatus;
    }

    void resetParticipation() {
        this.participationStatusAnswered = false;
        this.participationStatus = ParticipationStatus.AWAITING;
    }

    public void accept() {
        this.participationStatusAnswered = this.participationStatus != ParticipationStatus.ACCEPTED;
        this.participationStatus = ParticipationStatus.ACCEPTED;
    }

    public void decline() {
        this.participationStatusAnswered = this.participationStatus != ParticipationStatus.DECLINED;
        this.participationStatus = ParticipationStatus.DECLINED;
    }

    public void tentativelyAccept() {
        this.participationStatusAnswered = this.participationStatus != ParticipationStatus.TENTATIVE;
        this.participationStatus = ParticipationStatus.TENTATIVE;
    }

    boolean propertyChange() {
        return this.presenceStatusChanged || this.participationStatusAnswered;
    }

    public PresenceStatus getPresenceStatus() {
        return this.presenceStatus;
    }

    public void setPresenceStatus(PresenceStatus presenceStatus) {
        this.presenceStatusChanged = this.presenceStatus != presenceStatus;
        this.presenceStatus = presenceStatus;
    }

    public Attendee withPresenceStatus(PresenceStatus presenceStatus) {
        this.setPresenceStatus(presenceStatus);
        return this;
    }

    Attendee copy() {
        Attendee copy = this.newEmptyAttendee();
        copy.attendeeId = this.attendeeId;
        copy.delegate = this.delegate;
        copy.participationStatus = this.participationStatus;
        copy.presenceStatus = this.presenceStatus;
        copy.participationStatusAnswered = this.participationStatusAnswered;
        copy.presenceStatusChanged = this.presenceStatusChanged;
        copy.component = this.component;
        return copy;
    }

    private Attendee newEmptyAttendee() {
        try {
            Constructor<?> constructor = this.getClass().getDeclaredConstructor(new Class[0]);
            if (!constructor.canAccess(null)) {
                constructor.trySetAccessible();
            }
            return (Attendee)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    void setCalendarComponent(CalendarComponent calendarComponent) {
        this.component = calendarComponent;
    }

    @FunctionalInterface
    public static interface AttendeeSupplier {
        public Attendee to(CalendarComponent var1);
    }

    public static enum PresenceStatus {
        REQUIRED,
        OPTIONAL,
        INFORMATIVE;


        public boolean isRequired() {
            return this == REQUIRED;
        }

        public boolean isOptional() {
            return this == OPTIONAL;
        }

        public boolean isInformative() {
            return this == INFORMATIVE;
        }
    }

    public static enum ParticipationStatus {
        AWAITING,
        ACCEPTED,
        DECLINED,
        TENTATIVE,
        DELEGATED;


        public boolean isAwaiting() {
            return this == AWAITING;
        }

        public boolean isAccepted() {
            return this == ACCEPTED;
        }

        public boolean isDeclined() {
            return this == DECLINED;
        }

        public boolean isTentative() {
            return this == TENTATIVE;
        }

        public boolean isDelegated() {
            return this == DELEGATED;
        }
    }
}

