/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.util.Optional;
import java.util.Set;
import org.silverpeas.core.BasicIdentifier;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.component.service.SilverpeasComponentInstanceProvider;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.i18n.LocalizedResource;
import org.silverpeas.core.security.Securable;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.security.authorization.SpaceAccessControl;

public interface SilverpeasSharedComponentInstance
extends SilverpeasComponentInstance,
LocalizedResource,
Securable {
    public static Optional<SilverpeasSharedComponentInstance> getById(String sharedComponentInstanceId) {
        return SilverpeasComponentInstanceProvider.get().getSharedById(sharedComponentInstanceId);
    }

    public BasicIdentifier getIdentifier();

    @Override
    default public boolean canBeAccessedBy(User user) {
        return ComponentAccessControl.get().isUserAuthorized(user.getId(), this.getIdentifier());
    }

    @Override
    default public boolean canBeModifiedBy(User user) {
        return SpaceAccessControl.get().hasUserSpaceManagementAuthorization(user.getId(), this.getSpaceId());
    }

    @Override
    default public boolean canBeFiledInBy(User user) {
        Set<SilverpeasRole> role = ComponentAccessControl.get().getUserRoles(user.getId(), this.getId(), AccessControlContext.init());
        return role.stream().anyMatch(r -> r.isGreaterThanOrEquals(SilverpeasRole.WRITER));
    }
}

