/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.text.MessageFormat;
import org.silverpeas.core.ComponentResourceIdentifier;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.contribution.model.ContributionIdentifier;

public class ResourceReference
extends WAPrimaryKey
implements ComponentResourceIdentifier,
Serializable {
    private static final long serialVersionUID = 1551181996404764039L;
    private static final String ABSOLUTE_ID_FORMAT = "{0}:{1}";
    public static final String UNKNOWN_ID = "";

    public ResourceReference(ContributionIdentifier identifier) {
        super(identifier.getLocalId(), identifier.getComponentInstanceId());
    }

    public ResourceReference(String id) {
        this(id, UNKNOWN_ID);
    }

    public ResourceReference(String id, String componentInstanceId) {
        super(id, componentInstanceId);
    }

    public ResourceReference(WAPrimaryKey pk) {
        this(pk.getId(), pk.getInstanceId());
    }

    public static ResourceReference to(ComponentResourceIdentifier resource) {
        return new ResourceReference(resource.getLocalId(), resource.getComponentInstanceId());
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ResourceReference)) {
            return false;
        }
        ResourceReference otherRef = (ResourceReference)other;
        return Objects.equal((Object)this.getLocalId(), (Object)otherRef.getLocalId()) && Objects.equal((Object)this.getComponentInstanceId(), (Object)otherRef.getComponentInstanceId());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getLocalId(), this.getComponentInstanceId()});
    }

    @Override
    public String getLocalId() {
        return this.getId();
    }

    @Override
    public String getComponentInstanceId() {
        return this.getInstanceId();
    }

    @Override
    public String asString() {
        return MessageFormat.format(ABSOLUTE_ID_FORMAT, this.getComponentInstanceId(), this.getLocalId());
    }
}

