/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.sharing.repository;

import java.util.List;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.OrderBy;
import org.silverpeas.core.persistence.datasource.repository.PaginationCriterion;
import org.silverpeas.core.persistence.datasource.repository.jpa.BasicJpaEntityRepository;
import org.silverpeas.core.persistence.datasource.repository.jpa.NamedParameters;
import org.silverpeas.core.sharing.model.Ticket;
import org.silverpeas.core.sharing.repository.TicketRepository;
import org.silverpeas.core.util.SilverpeasList;

@Repository
public class TicketJpaRepository
extends BasicJpaEntityRepository<Ticket>
implements TicketRepository {
    @Override
    public List<Ticket> findAllTicketForSharedObjectId(Long sharedObjectId, String ticketType) {
        return this.listFromNamedQuery("Ticket.findAllTicketForSharedObjectId", this.newNamedParameters().add("sharedObjectId", (Object)sharedObjectId).add("ticketType", (Object)ticketType));
    }

    @Override
    public long countAllReservationsForUser(String userId) {
        return this.countFromJpqlString("SELECT t FROM Ticket t WHERE t.creatorId = :userId", this.newNamedParameters().add("userId", (Object)userId));
    }

    @Override
    public SilverpeasList<Ticket> findAllReservationsForUser(String userId, PaginationCriterion paginationCriterion, Ticket.QUERY_ORDER_BY orderBy) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT DISTINCT t FROM Ticket t WHERE t.creatorId = :userId");
        OrderBy.append((StringBuilder)sb, (OrderBy[])new OrderBy[]{orderBy != null ? orderBy.getOrderBy() : Ticket.QUERY_ORDER_BY.CREATION_DATE_DESC.getOrderBy()});
        return this.listFromJpqlString(sb.toString(), this.newNamedParameters().add("userId", (Object)userId), paginationCriterion);
    }

    @Override
    public void deleteAllTicketsForComponentInstance(String instanceId) {
        NamedParameters parameters = this.newNamedParameters().add("instanceId", (Object)instanceId);
        this.deleteFromJpqlQuery("delete from DownloadDetail d where d.ticket.id in (select t.id from Ticket t where t.componentId = :instanceId)", parameters);
        this.deleteFromJpqlQuery("delete from Ticket t where t.componentId = :instanceId", parameters);
    }
}

