/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.questioncontainer.answer.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.questioncontainer.answer.model.Answer;
import org.silverpeas.core.questioncontainer.answer.model.AnswerPK;
import org.silverpeas.core.questioncontainer.answer.model.AnswerRuntimeException;

public class AnswerDAO {
    public static final String ANSWERCOLUMNNAMES = "answerId, questionId, answerLabel, answerNbPoints, answerIsSolution, answerComment, answerNbVoters, answerIsOpened, answerImage, answerQuestionLink";
    private static final String SQL_DELETE_QUESTION_ANSWERS = "delete from SB_Question_Answer where questionId = ? ";
    private static final String SQL_DELETE_QUESTION_ANSWER = "delete from SB_Question_Answer where questionId = ? and answerId = ? ";
    private static final String SQL_INSERT_ANSWER = "insert into SB_Question_Answer values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_DELETE_ALL_QUESTION_ANSWERS = "DELETE FROM SB_Question_Answer  WHERE questionId in (SELECT questionId FROM SB_Question_Question WHERE instanceId = ?)";

    private AnswerDAO() {
    }

    private static Answer getAnswerFromResultSet(ResultSet rs, AnswerPK answerPK) throws SQLException {
        String id = rs.getString(1);
        String questionId = rs.getString(2);
        String label = rs.getString(3);
        int nbPoints = rs.getInt(4);
        boolean isSolution = false;
        if (rs.getInt(5) != 0) {
            isSolution = true;
        }
        String comment = rs.getString(6);
        int nbVoters = rs.getInt(7);
        boolean isOpened = false;
        if (rs.getInt(8) != 0) {
            isOpened = true;
        }
        String image = rs.getString(9);
        String questionLink = rs.getString(10);
        return new Answer(new AnswerPK(id, answerPK), new ResourceReference(questionId, answerPK.getInstanceId()), label, nbPoints, isSolution, comment, nbVoters, isOpened, image, questionLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Answer> getAnswersByQuestionPK(Connection con, ResourceReference questionPK) throws SQLException {
        ResultSet rs = null;
        AnswerPK answerPK = new AnswerPK(null, (WAPrimaryKey)questionPK);
        String selectStatement = "select answerId, questionId, answerLabel, answerNbPoints, answerIsSolution, answerComment, answerNbVoters, answerIsOpened, answerImage, answerQuestionLink from SB_Question_Answer where questionId = ? order by answerId ";
        ArrayList<Answer> result = new ArrayList<Answer>();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(selectStatement);
            prepStmt.setInt(1, Integer.parseInt(questionPK.getId()));
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                Answer answer = AnswerDAO.getAnswerFromResultSet(rs, answerPK);
                result.add(answer);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordThisAnswerAsVote(Connection con, ResourceReference questionPK, AnswerPK answerPK) throws SQLException {
        String updateStatement = "update SB_Question_Answer set answerNbVoters = answerNbVoters + 1 where answerId = ? and questionId = ?";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(updateStatement);
            prepStmt.setInt(1, Integer.parseInt(answerPK.getId()));
            prepStmt.setInt(2, Integer.parseInt(questionPK.getId()));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public static void addAnswersToAQuestion(Connection con, Collection<Answer> answers, ResourceReference questionPK) throws SQLException {
        if (answers != null) {
            for (Answer answer : answers) {
                AnswerDAO.addAnswerToAQuestion(con, answer, questionPK);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAnswerToAQuestion(Connection con, Answer answer, ResourceReference questionPK) throws SQLException {
        int newId;
        AnswerPK answerPK = new AnswerPK("unknown", (WAPrimaryKey)questionPK);
        try {
            newId = DBUtil.getNextId((String)answerPK.getTableName(), (String)"answerId");
        }
        catch (Exception e) {
            throw new AnswerRuntimeException(e);
        }
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(SQL_INSERT_ANSWER);
            prepStmt.setInt(1, newId);
            prepStmt.setInt(2, Integer.parseInt(questionPK.getId()));
            prepStmt.setString(3, answer.getLabel());
            prepStmt.setInt(4, answer.getNbPoints());
            if (answer.isSolution()) {
                prepStmt.setInt(5, 1);
            } else {
                prepStmt.setInt(5, 0);
            }
            prepStmt.setString(6, answer.getComment());
            prepStmt.setInt(7, 0);
            if (answer.isOpened()) {
                prepStmt.setInt(8, 1);
            } else {
                prepStmt.setInt(8, 0);
            }
            prepStmt.setString(9, answer.getImage());
            prepStmt.setString(10, answer.getQuestionLink());
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public static void deleteAnswersToAQuestion(Connection con, ResourceReference questionPK) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(SQL_DELETE_QUESTION_ANSWERS);
            prepStmt.setInt(1, Integer.parseInt(questionPK.getId()));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAnswerToAQuestion(Connection con, ResourceReference questionPK, String answerId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(SQL_DELETE_QUESTION_ANSWER);
            prepStmt.setInt(1, Integer.parseInt(questionPK.getId()));
            prepStmt.setInt(2, Integer.parseInt(answerId));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public static void deleteAnswersToAllQuestions(Connection con, String instanceId) throws SQLException {
        try (PreparedStatement deletion = con.prepareStatement(SQL_DELETE_ALL_QUESTION_ANSWERS);){
            deletion.setString(1, instanceId);
            deletion.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAnswerToAQuestion(Connection con, ResourceReference questionPK, Answer answer) throws SQLException {
        String updateStatement = "update SB_Question_Answer set questionId = ?, set answerLabel = ?, set answerNbPoints = ?, set answerIsSolution = ?, set answerComment = ?, set answerNbVoters = ?, set answerIsOpened = ?, set answerImage = ?, set answerQuestionLink = ?, where answerId = ? ";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(updateStatement);
            prepStmt.setInt(1, Integer.parseInt(questionPK.getId()));
            prepStmt.setString(2, answer.getLabel());
            prepStmt.setInt(3, answer.getNbPoints());
            if (answer.isSolution()) {
                prepStmt.setInt(4, 1);
            } else {
                prepStmt.setInt(4, 0);
            }
            prepStmt.setString(5, answer.getComment());
            prepStmt.setInt(6, answer.getNbVoters());
            if (answer.isOpened()) {
                prepStmt.setInt(7, 1);
            } else {
                prepStmt.setInt(7, 0);
            }
            prepStmt.setString(8, answer.getImage());
            prepStmt.setString(9, answer.getQuestionLink());
            prepStmt.setString(10, answer.getPK().getId());
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }
}

