/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.resources;

import edu.psu.swe.scim.spec.annotation.ScimAttribute;
import edu.psu.swe.scim.spec.phonenumber.PhoneNumberLexer;
import edu.psu.swe.scim.spec.phonenumber.PhoneNumberParseException;
import edu.psu.swe.scim.spec.phonenumber.PhoneNumberParseTreeListener;
import edu.psu.swe.scim.spec.phonenumber.PhoneNumberParser;
import edu.psu.swe.scim.spec.resources.KeyedResource;
import edu.psu.swe.scim.spec.resources.TypedAttribute;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlType
@XmlAccessorType(value=XmlAccessType.NONE)
public class PhoneNumber
extends KeyedResource
implements Serializable,
TypedAttribute {
    private static final long serialVersionUID = 607319505715224096L;
    private static final String VISUAL_SEPARATORS = "[\\(\\)\\-\\.]";
    private static boolean strict = true;
    @ScimAttribute(description="Phone number of the User")
    String value;
    @XmlElement
    @ScimAttribute(description="A human readable name, primarily used for display purposes. READ-ONLY.")
    String display;
    @XmlElement
    @ScimAttribute(canonicalValueList={"work", "home", "mobile", "fax", "pager", "other"}, description="A label indicating the attribute's function; e.g., 'work' or 'home' or 'mobile' etc.")
    String type;
    @XmlElement
    @ScimAttribute(description="A Boolean value indicating the 'primary' or preferred attribute value for this attribute, e.g. the preferred phone number or primary phone number. The primary attribute value 'true' MUST appear no more than once.")
    Boolean primary = false;
    boolean isGlobalNumber = false;
    String number;
    String extension;
    String subAddress;
    String phoneContext;
    boolean isDomainPhoneContext = false;
    Map<String, String> params;

    public void addParam(String name, String value) {
        if (this.params == null) {
            this.params = new HashMap<String, String>();
        }
        this.params.put(name, value);
    }

    @XmlElement
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws PhoneNumberParseException {
        if (value == null) {
            throw new PhoneNumberParseException("null values are illegal for phone numbers");
        }
        if (strict) {
            PhoneNumberLexer phoneNumberLexer = new PhoneNumberLexer((CharStream)new ANTLRInputStream(value));
            PhoneNumberParser p = new PhoneNumberParser((TokenStream)new CommonTokenStream((TokenSource)phoneNumberLexer));
            p.setBuildParseTree(true);
            p.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

                public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                    throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, e);
                }
            });
            PhoneNumberParseTreeListener tpl = new PhoneNumberParseTreeListener();
            try {
                PhoneNumberParser.PhoneNumberContext tree = p.phoneNumber();
                ParseTreeWalker.DEFAULT.walk((ParseTreeListener)tpl, (ParseTree)tree);
            }
            catch (IllegalStateException e) {
                throw new PhoneNumberParseException(e);
            }
            PhoneNumber parsedPhoneNumber = tpl.getPhoneNumber();
            this.value = parsedPhoneNumber.getValue();
            this.number = parsedPhoneNumber.getNumber();
            this.extension = parsedPhoneNumber.getExtension();
            this.subAddress = parsedPhoneNumber.getSubAddress();
            this.phoneContext = parsedPhoneNumber.getPhoneContext();
            this.params = parsedPhoneNumber.getParams();
            this.isGlobalNumber = parsedPhoneNumber.isGlobalNumber();
            this.isDomainPhoneContext = parsedPhoneNumber.isDomainPhoneContext();
        } else {
            this.value = value;
        }
    }

    public boolean equals(Object obj) {
        String otherExtensionWithoutVisualSeparators;
        String otherNumberWithoutVisualSeparators;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PhoneNumber other = (PhoneNumber)obj;
        if (this.isGlobalNumber != other.isGlobalNumber) {
            return false;
        }
        String numberWithoutVisualSeparators = this.number != null ? this.number.replaceAll(VISUAL_SEPARATORS, "") : null;
        String string = otherNumberWithoutVisualSeparators = other.number != null ? other.number.replaceAll(VISUAL_SEPARATORS, "") : null;
        if (numberWithoutVisualSeparators == null ? otherNumberWithoutVisualSeparators != null : !numberWithoutVisualSeparators.equals(otherNumberWithoutVisualSeparators)) {
            return false;
        }
        String extensionWithoutVisualSeparators = this.extension != null ? this.extension.replaceAll(VISUAL_SEPARATORS, "") : null;
        String string2 = otherExtensionWithoutVisualSeparators = other.extension != null ? other.extension.replaceAll(VISUAL_SEPARATORS, "") : null;
        if (extensionWithoutVisualSeparators == null ? otherExtensionWithoutVisualSeparators != null : !extensionWithoutVisualSeparators.equals(otherExtensionWithoutVisualSeparators)) {
            return false;
        }
        if (this.subAddress == null ? other.subAddress != null : !this.subAddress.equalsIgnoreCase(other.subAddress)) {
            return false;
        }
        String phoneContextTemp = this.phoneContext;
        if (!StringUtils.isBlank((CharSequence)this.phoneContext) && !this.isDomainPhoneContext) {
            phoneContextTemp = this.phoneContext.replaceAll(VISUAL_SEPARATORS, "");
        }
        String otherPhoneContextTemp = other.phoneContext;
        if (!StringUtils.isBlank((CharSequence)other.phoneContext) && !other.isDomainPhoneContext) {
            otherPhoneContextTemp = other.phoneContext.replaceAll(VISUAL_SEPARATORS, "");
        }
        if (phoneContextTemp == null ? otherPhoneContextTemp != null : !phoneContextTemp.equalsIgnoreCase(otherPhoneContextTemp)) {
            return false;
        }
        if (!this.equalsIgnoreCaseAndOrderParams(other.params)) {
            return false;
        }
        if (this.primary == null ? other.primary != null : !this.primary.equals(other.primary)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equalsIgnoreCase(other.type));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isGlobalNumber ? 1231 : 1237);
        result = 31 * result + (this.number == null ? 0 : this.number.replaceAll(VISUAL_SEPARATORS, "").hashCode());
        result = 31 * result + (this.extension == null ? 0 : this.extension.replaceAll(VISUAL_SEPARATORS, "").hashCode());
        result = 31 * result + (this.subAddress == null ? 0 : this.subAddress.toLowerCase().hashCode());
        result = 31 * result + (this.phoneContext == null ? 0 : (this.isDomainPhoneContext ? this.phoneContext.toLowerCase().hashCode() : this.phoneContext.replaceAll(VISUAL_SEPARATORS, "").hashCode()));
        result = 31 * result + (this.params == null ? 0 : this.paramsToLowerCase().hashCode());
        result = 31 * result + (this.primary == null ? 0 : this.primary.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.toLowerCase().hashCode());
        return result;
    }

    HashMap<String, String> paramsToLowerCase() {
        HashMap<String, String> paramsLowercase = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            paramsLowercase.put(entry.getKey().toLowerCase(), entry.getValue().toLowerCase());
        }
        return paramsLowercase;
    }

    boolean equalsIgnoreCaseAndOrderParams(Map<String, String> otherParams) {
        if (this.params == null && otherParams == null) {
            return true;
        }
        if (this.params == null && otherParams != null || this.params != null && otherParams == null || this.params.size() != otherParams.size()) {
            return false;
        }
        HashMap<String, String> paramsLowercase = this.paramsToLowerCase();
        for (Map.Entry<String, String> entry : otherParams.entrySet()) {
            String foundValue = paramsLowercase.get(entry.getKey().toLowerCase());
            if (entry.getValue().equalsIgnoreCase(foundValue)) continue;
            return false;
        }
        return true;
    }

    public static boolean isStrict() {
        return strict;
    }

    public static void setStrict(boolean strict) {
        PhoneNumber.strict = strict;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean getPrimary() {
        return this.primary;
    }

    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }

    public boolean isGlobalNumber() {
        return this.isGlobalNumber;
    }

    public String getNumber() {
        return this.number;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getSubAddress() {
        return this.subAddress;
    }

    public String getPhoneContext() {
        return this.phoneContext;
    }

    public boolean isDomainPhoneContext() {
        return this.isDomainPhoneContext;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public static class GlobalPhoneNumberBuilder
    extends PhoneNumberBuilder {
        String globalNumber;

        public GlobalPhoneNumberBuilder() {
            this.isGlobalNumber = true;
        }

        public GlobalPhoneNumberBuilder globalNumber(String globalNumber) {
            this.globalNumber = globalNumber;
            if (globalNumber != null) {
                this.number = globalNumber.startsWith("+") ? globalNumber : "+" + globalNumber;
            }
            return this;
        }

        @Override
        public PhoneNumber build() throws PhoneNumberParseException {
            if (StringUtils.isBlank((CharSequence)this.globalNumber) || !this.globalNumber.matches("^(\\+)?[\\d\\.\\-\\(\\)]+$")) {
                throw new IllegalArgumentException("GlobalPhoneNumberBuilder globalNumber must contain only numeric characters, optional ., -, (, ) visual separators, and an optional plus (+) prefix.");
            }
            return super.build();
        }
    }

    public static class LocalPhoneNumberBuilder
    extends PhoneNumberBuilder {
        String subscriberNumber;
        String countryCode;
        String areaCode;
        String domainName;

        public LocalPhoneNumberBuilder subscriberNumber(String subscriberNumber) {
            this.subscriberNumber = subscriberNumber;
            this.number = subscriberNumber;
            return this;
        }

        public LocalPhoneNumberBuilder countryCode(String countryCode) {
            String localCode = countryCode;
            if (localCode != null && !localCode.isEmpty() && (localCode = localCode.trim()).length() > 0 && localCode.charAt(0) != '+') {
                localCode = '+' + localCode;
            }
            this.countryCode = localCode;
            return this;
        }

        public LocalPhoneNumberBuilder areaCode(String areaCode) {
            this.areaCode = areaCode;
            return this;
        }

        public LocalPhoneNumberBuilder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public LocalPhoneNumberBuilder isDomainPhoneContext(boolean hasDomainPhoneContext) {
            this.isDomainPhoneContext = hasDomainPhoneContext;
            return this;
        }

        @Override
        public PhoneNumber build() throws PhoneNumberParseException {
            if (StringUtils.isBlank((CharSequence)this.subscriberNumber) || !this.subscriberNumber.matches("^[\\d\\.\\-\\(\\)]+$")) {
                throw new IllegalArgumentException("LocalPhoneNumberBuilder subscriberNumber must contain only numeric characters and optional ., -, (, ) visual separator characters.");
            }
            if (StringUtils.isBlank((CharSequence)this.countryCode) && StringUtils.isBlank((CharSequence)this.domainName)) {
                throw new IllegalArgumentException("LocalPhoneNumberBuilder must have values for domainName or countryCode.");
            }
            if (StringUtils.isBlank((CharSequence)this.domainName)) {
                if (StringUtils.isBlank((CharSequence)this.countryCode) || !this.countryCode.matches("^(\\+)?[1-9][0-9]{0,2}$")) {
                    throw new IllegalArgumentException("LocalPhoneNumberBuilder countryCode must contain only numeric characters and an optional plus (+) prefix.");
                }
                if (this.areaCode != null && !StringUtils.isNumeric((CharSequence)this.areaCode)) {
                    throw new IllegalArgumentException("LocalPhoneNumberBuilder areaCode must contain only numberic characters.");
                }
                this.phoneContext = !this.countryCode.startsWith("+") ? "+" + this.countryCode : this.countryCode;
                if (!StringUtils.isBlank((CharSequence)this.areaCode)) {
                    this.phoneContext = this.phoneContext + "-" + this.areaCode;
                }
            } else {
                if (!this.domainName.matches("^[a-zA-Z0-9\\.\\-]+$")) {
                    throw new IllegalArgumentException("LocalPhoneNumberBuilder domainName must contain only alphanumeric, . and - characters.");
                }
                this.phoneContext = this.domainName;
            }
            return super.build();
        }
    }

    public static abstract class PhoneNumberBuilder {
        static final Logger LOGGER = LoggerFactory.getLogger(PhoneNumberBuilder.class);
        final String HYPHEN = "-";
        final String INTERNATIONAL_PREFIX = "+";
        final String PREFIX = "tel:%s";
        final String EXTENSTION_PREFIX = ";ext=%s";
        final String ISUB_PREFIX = ";isub=%s";
        final String CONTEXT_PREFIX = ";phone-context=%s";
        final String PARAMS_STRING = ";%s=%s";
        final String LOCAL_SUBSCRIBER_NUMBER_REGEX = "^[\\d\\.\\-\\(\\)]+$";
        final String DOMAIN_NAME_REGEX = "^[a-zA-Z0-9\\.\\-]+$";
        final String GLOBAL_NUMBER_REGEX = "^(\\+)?[\\d\\.\\-\\(\\)]+$";
        final String COUNTRY_CODE_REGEX = "^(\\+)?[1-9][0-9]{0,2}$";
        String number;
        String display;
        String extension;
        String subAddress;
        String phoneContext;
        Map<String, String> params;
        boolean isGlobalNumber = false;
        boolean isDomainPhoneContext = false;

        public PhoneNumberBuilder display(String display) {
            this.display = display;
            return this;
        }

        public PhoneNumberBuilder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public PhoneNumberBuilder subAddress(String subAddress) {
            this.subAddress = subAddress;
            return this;
        }

        public PhoneNumberBuilder phoneContext(String phoneContext) {
            this.phoneContext = phoneContext;
            return this;
        }

        public PhoneNumberBuilder param(String name, String value) {
            if (this.params == null) {
                this.params = new HashMap<String, String>();
            }
            this.params.put(name, value);
            return this;
        }

        String getFormattedExtension() {
            if (this.extension != null && !this.extension.isEmpty()) {
                return String.format(";ext=%s", this.extension);
            }
            return null;
        }

        String getFormattedSubAddress() {
            if (this.subAddress != null && !this.subAddress.isEmpty()) {
                return String.format(";isub=%s", this.subAddress);
            }
            return null;
        }

        String getFormattedPhoneContext() {
            if (this.phoneContext != null && !this.phoneContext.isEmpty()) {
                return String.format(";phone-context=%s", this.phoneContext);
            }
            return null;
        }

        String getFormattedParams() {
            String paramsFormatted = "";
            if (this.params != null) {
                for (Map.Entry<String, String> entry : this.params.entrySet()) {
                    paramsFormatted = paramsFormatted + String.format(";%s=%s", entry.getKey(), entry.getValue() != null ? entry.getValue() : "");
                }
            }
            return !paramsFormatted.isEmpty() ? paramsFormatted : null;
        }

        String getFormattedValue() {
            String fParams;
            String fContext;
            String fSubAddr;
            String valueString = String.format("tel:%s", this.number);
            String fExtension = this.getFormattedExtension();
            if (fExtension != null) {
                valueString = valueString + fExtension;
            }
            if ((fSubAddr = this.getFormattedSubAddress()) != null) {
                valueString = valueString + fSubAddr;
            }
            if ((fContext = this.getFormattedPhoneContext()) != null) {
                valueString = valueString + fContext;
            }
            if ((fParams = this.getFormattedParams()) != null) {
                valueString = valueString + fParams;
            }
            return !valueString.isEmpty() ? valueString : null;
        }

        public PhoneNumber build() throws PhoneNumberParseException {
            return this.build(true);
        }

        public PhoneNumber build(boolean validate) throws PhoneNumberParseException {
            if (!StringUtils.isBlank((CharSequence)this.extension) && !StringUtils.isBlank((CharSequence)this.subAddress)) {
                throw new IllegalArgumentException("PhoneNumberBuilder cannot have a value for both extension and subAddress.");
            }
            if (this.extension != null && !this.extension.matches("^[\\d\\.\\-\\(\\)]+$")) {
                throw new IllegalArgumentException("PhoneNumberBuilder extension must contain only numeric characters and optional ., -, (, ) visual separator characters.");
            }
            if (this.params != null && !this.params.isEmpty() && (this.params.get("") != null || this.params.get(null) != null || this.params.values().contains(null) || this.params.values().contains(""))) {
                throw new IllegalArgumentException("PhoneNumberBuilder params names and values cannot be null or empty.");
            }
            PhoneNumber phoneNumber = new PhoneNumber();
            String formattedValue = this.getFormattedValue();
            LOGGER.debug("" + formattedValue);
            if (validate) {
                phoneNumber.setValue(formattedValue);
            } else {
                phoneNumber.value = formattedValue;
                phoneNumber.extension = this.extension;
                phoneNumber.isDomainPhoneContext = this.isDomainPhoneContext;
                phoneNumber.isGlobalNumber = this.isGlobalNumber;
                phoneNumber.number = this.number;
                phoneNumber.params = this.params;
                phoneNumber.phoneContext = this.phoneContext;
                phoneNumber.subAddress = this.subAddress;
            }
            return phoneNumber;
        }

        public String getHYPHEN() {
            return this.HYPHEN;
        }

        public String getINTERNATIONAL_PREFIX() {
            return this.INTERNATIONAL_PREFIX;
        }

        public String getPREFIX() {
            return this.PREFIX;
        }

        public String getEXTENSTION_PREFIX() {
            return this.EXTENSTION_PREFIX;
        }

        public String getISUB_PREFIX() {
            return this.ISUB_PREFIX;
        }

        public String getCONTEXT_PREFIX() {
            return this.CONTEXT_PREFIX;
        }

        public String getPARAMS_STRING() {
            return this.PARAMS_STRING;
        }

        public String getLOCAL_SUBSCRIBER_NUMBER_REGEX() {
            return this.LOCAL_SUBSCRIBER_NUMBER_REGEX;
        }

        public String getDOMAIN_NAME_REGEX() {
            return this.DOMAIN_NAME_REGEX;
        }

        public String getGLOBAL_NUMBER_REGEX() {
            return this.GLOBAL_NUMBER_REGEX;
        }

        public String getCOUNTRY_CODE_REGEX() {
            return this.COUNTRY_CODE_REGEX;
        }

        public String getNumber() {
            return this.number;
        }

        public String getDisplay() {
            return this.display;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getSubAddress() {
            return this.subAddress;
        }

        public String getPhoneContext() {
            return this.phoneContext;
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        public boolean isGlobalNumber() {
            return this.isGlobalNumber;
        }

        public boolean isDomainPhoneContext() {
            return this.isDomainPhoneContext;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public void setDisplay(String display) {
            this.display = display;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public void setSubAddress(String subAddress) {
            this.subAddress = subAddress;
        }

        public void setPhoneContext(String phoneContext) {
            this.phoneContext = phoneContext;
        }

        public void setParams(Map<String, String> params) {
            this.params = params;
        }

        public void setGlobalNumber(boolean isGlobalNumber) {
            this.isGlobalNumber = isGlobalNumber;
        }

        public void setDomainPhoneContext(boolean isDomainPhoneContext) {
            this.isDomainPhoneContext = isDomainPhoneContext;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PhoneNumberBuilder)) {
                return false;
            }
            PhoneNumberBuilder other = (PhoneNumberBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$HYPHEN = this.getHYPHEN();
            String other$HYPHEN = other.getHYPHEN();
            if (this$HYPHEN == null ? other$HYPHEN != null : !this$HYPHEN.equals(other$HYPHEN)) {
                return false;
            }
            String this$INTERNATIONAL_PREFIX = this.getINTERNATIONAL_PREFIX();
            String other$INTERNATIONAL_PREFIX = other.getINTERNATIONAL_PREFIX();
            if (this$INTERNATIONAL_PREFIX == null ? other$INTERNATIONAL_PREFIX != null : !this$INTERNATIONAL_PREFIX.equals(other$INTERNATIONAL_PREFIX)) {
                return false;
            }
            String this$PREFIX = this.getPREFIX();
            String other$PREFIX = other.getPREFIX();
            if (this$PREFIX == null ? other$PREFIX != null : !this$PREFIX.equals(other$PREFIX)) {
                return false;
            }
            String this$EXTENSTION_PREFIX = this.getEXTENSTION_PREFIX();
            String other$EXTENSTION_PREFIX = other.getEXTENSTION_PREFIX();
            if (this$EXTENSTION_PREFIX == null ? other$EXTENSTION_PREFIX != null : !this$EXTENSTION_PREFIX.equals(other$EXTENSTION_PREFIX)) {
                return false;
            }
            String this$ISUB_PREFIX = this.getISUB_PREFIX();
            String other$ISUB_PREFIX = other.getISUB_PREFIX();
            if (this$ISUB_PREFIX == null ? other$ISUB_PREFIX != null : !this$ISUB_PREFIX.equals(other$ISUB_PREFIX)) {
                return false;
            }
            String this$CONTEXT_PREFIX = this.getCONTEXT_PREFIX();
            String other$CONTEXT_PREFIX = other.getCONTEXT_PREFIX();
            if (this$CONTEXT_PREFIX == null ? other$CONTEXT_PREFIX != null : !this$CONTEXT_PREFIX.equals(other$CONTEXT_PREFIX)) {
                return false;
            }
            String this$PARAMS_STRING = this.getPARAMS_STRING();
            String other$PARAMS_STRING = other.getPARAMS_STRING();
            if (this$PARAMS_STRING == null ? other$PARAMS_STRING != null : !this$PARAMS_STRING.equals(other$PARAMS_STRING)) {
                return false;
            }
            String this$LOCAL_SUBSCRIBER_NUMBER_REGEX = this.getLOCAL_SUBSCRIBER_NUMBER_REGEX();
            String other$LOCAL_SUBSCRIBER_NUMBER_REGEX = other.getLOCAL_SUBSCRIBER_NUMBER_REGEX();
            if (this$LOCAL_SUBSCRIBER_NUMBER_REGEX == null ? other$LOCAL_SUBSCRIBER_NUMBER_REGEX != null : !this$LOCAL_SUBSCRIBER_NUMBER_REGEX.equals(other$LOCAL_SUBSCRIBER_NUMBER_REGEX)) {
                return false;
            }
            String this$DOMAIN_NAME_REGEX = this.getDOMAIN_NAME_REGEX();
            String other$DOMAIN_NAME_REGEX = other.getDOMAIN_NAME_REGEX();
            if (this$DOMAIN_NAME_REGEX == null ? other$DOMAIN_NAME_REGEX != null : !this$DOMAIN_NAME_REGEX.equals(other$DOMAIN_NAME_REGEX)) {
                return false;
            }
            String this$GLOBAL_NUMBER_REGEX = this.getGLOBAL_NUMBER_REGEX();
            String other$GLOBAL_NUMBER_REGEX = other.getGLOBAL_NUMBER_REGEX();
            if (this$GLOBAL_NUMBER_REGEX == null ? other$GLOBAL_NUMBER_REGEX != null : !this$GLOBAL_NUMBER_REGEX.equals(other$GLOBAL_NUMBER_REGEX)) {
                return false;
            }
            String this$COUNTRY_CODE_REGEX = this.getCOUNTRY_CODE_REGEX();
            String other$COUNTRY_CODE_REGEX = other.getCOUNTRY_CODE_REGEX();
            if (this$COUNTRY_CODE_REGEX == null ? other$COUNTRY_CODE_REGEX != null : !this$COUNTRY_CODE_REGEX.equals(other$COUNTRY_CODE_REGEX)) {
                return false;
            }
            String this$number = this.getNumber();
            String other$number = other.getNumber();
            if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
                return false;
            }
            String this$display = this.getDisplay();
            String other$display = other.getDisplay();
            if (this$display == null ? other$display != null : !this$display.equals(other$display)) {
                return false;
            }
            String this$extension = this.getExtension();
            String other$extension = other.getExtension();
            if (this$extension == null ? other$extension != null : !this$extension.equals(other$extension)) {
                return false;
            }
            String this$subAddress = this.getSubAddress();
            String other$subAddress = other.getSubAddress();
            if (this$subAddress == null ? other$subAddress != null : !this$subAddress.equals(other$subAddress)) {
                return false;
            }
            String this$phoneContext = this.getPhoneContext();
            String other$phoneContext = other.getPhoneContext();
            if (this$phoneContext == null ? other$phoneContext != null : !this$phoneContext.equals(other$phoneContext)) {
                return false;
            }
            Map<String, String> this$params = this.getParams();
            Map<String, String> other$params = other.getParams();
            if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
                return false;
            }
            if (this.isGlobalNumber() != other.isGlobalNumber()) {
                return false;
            }
            return this.isDomainPhoneContext() == other.isDomainPhoneContext();
        }

        protected boolean canEqual(Object other) {
            return other instanceof PhoneNumberBuilder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $HYPHEN = this.getHYPHEN();
            result = result * 59 + ($HYPHEN == null ? 43 : $HYPHEN.hashCode());
            String $INTERNATIONAL_PREFIX = this.getINTERNATIONAL_PREFIX();
            result = result * 59 + ($INTERNATIONAL_PREFIX == null ? 43 : $INTERNATIONAL_PREFIX.hashCode());
            String $PREFIX = this.getPREFIX();
            result = result * 59 + ($PREFIX == null ? 43 : $PREFIX.hashCode());
            String $EXTENSTION_PREFIX = this.getEXTENSTION_PREFIX();
            result = result * 59 + ($EXTENSTION_PREFIX == null ? 43 : $EXTENSTION_PREFIX.hashCode());
            String $ISUB_PREFIX = this.getISUB_PREFIX();
            result = result * 59 + ($ISUB_PREFIX == null ? 43 : $ISUB_PREFIX.hashCode());
            String $CONTEXT_PREFIX = this.getCONTEXT_PREFIX();
            result = result * 59 + ($CONTEXT_PREFIX == null ? 43 : $CONTEXT_PREFIX.hashCode());
            String $PARAMS_STRING = this.getPARAMS_STRING();
            result = result * 59 + ($PARAMS_STRING == null ? 43 : $PARAMS_STRING.hashCode());
            String $LOCAL_SUBSCRIBER_NUMBER_REGEX = this.getLOCAL_SUBSCRIBER_NUMBER_REGEX();
            result = result * 59 + ($LOCAL_SUBSCRIBER_NUMBER_REGEX == null ? 43 : $LOCAL_SUBSCRIBER_NUMBER_REGEX.hashCode());
            String $DOMAIN_NAME_REGEX = this.getDOMAIN_NAME_REGEX();
            result = result * 59 + ($DOMAIN_NAME_REGEX == null ? 43 : $DOMAIN_NAME_REGEX.hashCode());
            String $GLOBAL_NUMBER_REGEX = this.getGLOBAL_NUMBER_REGEX();
            result = result * 59 + ($GLOBAL_NUMBER_REGEX == null ? 43 : $GLOBAL_NUMBER_REGEX.hashCode());
            String $COUNTRY_CODE_REGEX = this.getCOUNTRY_CODE_REGEX();
            result = result * 59 + ($COUNTRY_CODE_REGEX == null ? 43 : $COUNTRY_CODE_REGEX.hashCode());
            String $number = this.getNumber();
            result = result * 59 + ($number == null ? 43 : $number.hashCode());
            String $display = this.getDisplay();
            result = result * 59 + ($display == null ? 43 : $display.hashCode());
            String $extension = this.getExtension();
            result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
            String $subAddress = this.getSubAddress();
            result = result * 59 + ($subAddress == null ? 43 : $subAddress.hashCode());
            String $phoneContext = this.getPhoneContext();
            result = result * 59 + ($phoneContext == null ? 43 : $phoneContext.hashCode());
            Map<String, String> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            result = result * 59 + (this.isGlobalNumber() ? 79 : 97);
            result = result * 59 + (this.isDomainPhoneContext() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "PhoneNumber.PhoneNumberBuilder(HYPHEN=" + this.getHYPHEN() + ", INTERNATIONAL_PREFIX=" + this.getINTERNATIONAL_PREFIX() + ", PREFIX=" + this.getPREFIX() + ", EXTENSTION_PREFIX=" + this.getEXTENSTION_PREFIX() + ", ISUB_PREFIX=" + this.getISUB_PREFIX() + ", CONTEXT_PREFIX=" + this.getCONTEXT_PREFIX() + ", PARAMS_STRING=" + this.getPARAMS_STRING() + ", LOCAL_SUBSCRIBER_NUMBER_REGEX=" + this.getLOCAL_SUBSCRIBER_NUMBER_REGEX() + ", DOMAIN_NAME_REGEX=" + this.getDOMAIN_NAME_REGEX() + ", GLOBAL_NUMBER_REGEX=" + this.getGLOBAL_NUMBER_REGEX() + ", COUNTRY_CODE_REGEX=" + this.getCOUNTRY_CODE_REGEX() + ", number=" + this.getNumber() + ", display=" + this.getDisplay() + ", extension=" + this.getExtension() + ", subAddress=" + this.getSubAddress() + ", phoneContext=" + this.getPhoneContext() + ", params=" + this.getParams() + ", isGlobalNumber=" + this.isGlobalNumber() + ", isDomainPhoneContext=" + this.isDomainPhoneContext() + ")";
        }
    }
}

