/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.extension;

import edu.psu.swe.scim.spec.annotation.ScimExtensionType;
import edu.psu.swe.scim.spec.exception.InvalidExtensionException;
import edu.psu.swe.scim.spec.resources.ScimExtension;
import edu.psu.swe.scim.spec.resources.ScimResource;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScimExtensionRegistry {
    private static final Logger log = LoggerFactory.getLogger(ScimExtensionRegistry.class);
    private static final ScimExtensionRegistry INSTANCE = new ScimExtensionRegistry();
    private Map<Class<? extends ScimResource>, Map<String, Class<? extends ScimExtension>>> registry = new HashMap<Class<? extends ScimResource>, Map<String, Class<? extends ScimExtension>>>();

    private ScimExtensionRegistry() {
    }

    public Class<? extends ScimExtension> getExtensionClass(Class<? extends ScimResource> resourceClass, String urn) {
        Map<String, Class<? extends ScimExtension>> resourceMap;
        Class<? extends ScimExtension> extensionClass = null;
        if (this.registry.containsKey(resourceClass) && (resourceMap = this.registry.get(resourceClass)).containsKey(urn)) {
            extensionClass = resourceMap.get(urn);
        }
        return extensionClass;
    }

    public static ScimExtensionRegistry getInstance() {
        return INSTANCE;
    }

    public void registerExtension(Class<? extends ScimResource> resourceClass, Class<? extends ScimExtension> extensionClass) {
        ScimExtensionType[] se = (ScimExtensionType[])extensionClass.getAnnotationsByType(ScimExtensionType.class);
        if (se.length == 0 || se.length > 1) {
            throw new InvalidExtensionException("Registered extensions must have an ScimExtensionType annotation");
        }
        String urn = se[0].id();
        log.debug("Registering extension for URN: " + urn);
        log.debug("    (associated resource class: " + resourceClass.getSimpleName() + ")");
        log.debug("    (associated extension class: " + extensionClass.getSimpleName() + ")");
        Map<String, Class<? extends ScimExtension>> resourceMap = this.registry.get(resourceClass);
        if (resourceMap == null) {
            resourceMap = new HashMap<String, Class<? extends ScimExtension>>();
            this.registry.put(resourceClass, resourceMap);
        }
        if (!resourceMap.containsKey(urn)) {
            resourceMap.put(urn, extensionClass);
        }
    }
}

