/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.components.formsonline.model.RequestValidationCriteria;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.util.CollectionUtil;

public class RequestCriteria {
    private final List<String> componentInstanceIds = new ArrayList<String>();
    private final List<String> ids = new ArrayList<String>();
    private final List<String> formIds = new ArrayList<String>();
    private final List<Integer> states = new ArrayList<Integer>();
    private final List<QUERY_ORDER_BY> orderByList = new ArrayList<QUERY_ORDER_BY>();
    private final List<String> creatorIds = new ArrayList<String>();
    private RequestValidationCriteria validationCriteria;
    private PaginationPage pagination;

    public static RequestCriteria onComponentInstanceIds(String ... componentInstanceIds) {
        return RequestCriteria.onComponentInstanceIds(Stream.of(componentInstanceIds).collect(Collectors.toList()));
    }

    public static RequestCriteria onComponentInstanceIds(Collection<String> componentInstanceIds) {
        RequestCriteria criteria = new RequestCriteria();
        criteria.componentInstanceIds.addAll(componentInstanceIds);
        return criteria;
    }

    public RequestCriteria andIds(String ... ids) {
        return this.andIds(Stream.of(ids).collect(Collectors.toList()));
    }

    public RequestCriteria andIds(Collection<String> ids) {
        if (ids != null) {
            this.ids.addAll(ids);
        }
        return this;
    }

    public RequestCriteria andFormIds(String ... formIds) {
        return this.andFormIds(Stream.of(formIds).collect(Collectors.toList()));
    }

    public RequestCriteria andFormIds(Collection<String> formIds) {
        if (formIds != null) {
            this.formIds.addAll(formIds);
        }
        return this;
    }

    public RequestCriteria andStates(Integer ... states) {
        return this.andStates(Stream.of(states).collect(Collectors.toList()));
    }

    public RequestCriteria andStates(Collection<Integer> states) {
        if (states != null) {
            this.states.addAll(states);
        }
        return this;
    }

    public RequestCriteria andCreatorId(String creatorId) {
        return this.andCreatorIds(Collections.singletonList(creatorId));
    }

    public RequestCriteria andCreatorIds(Collection<String> creatorIds) {
        if (creatorIds != null) {
            this.creatorIds.addAll(creatorIds);
        }
        return this;
    }

    public RequestCriteria andValidationCriteria(RequestValidationCriteria validationCriteria) {
        this.validationCriteria = validationCriteria;
        return this;
    }

    public RequestCriteria orderBy(QUERY_ORDER_BY ... orderBies) {
        CollectionUtil.addAllIgnoreNull(this.orderByList, (Object[])orderBies);
        return this;
    }

    public RequestCriteria paginateBy(PaginationPage pagination) {
        this.pagination = pagination;
        return this;
    }

    boolean emptyResultWhenNoFilteringOnComponentInstances() {
        return this.componentInstanceIds.isEmpty();
    }

    List<String> getComponentInstanceIds() {
        return this.componentInstanceIds;
    }

    List<String> getIds() {
        return this.ids;
    }

    List<String> getFormIds() {
        return this.formIds;
    }

    List<Integer> getStates() {
        return this.states;
    }

    List<String> getCreatorIds() {
        return this.creatorIds;
    }

    RequestValidationCriteria getValidationCriteria() {
        return this.validationCriteria;
    }

    PaginationPage getPagination() {
        return this.pagination;
    }

    List<QUERY_ORDER_BY> getOrderByList() {
        return this.orderByList;
    }

    public String toString() {
        return new StringJoiner(", ", RequestCriteria.class.getSimpleName() + "[", "]").add("componentInstanceIds=" + String.valueOf(this.componentInstanceIds)).add("ids=" + String.valueOf(this.ids)).add("formIds=" + String.valueOf(this.formIds)).add("states=" + String.valueOf(this.states)).add("orderByList=" + String.valueOf(this.orderByList)).add("creatorIds=" + String.valueOf(this.creatorIds)).add("validationCriteria=" + String.valueOf(this.validationCriteria)).add("pagination=" + String.valueOf(this.pagination)).toString();
    }

    public static enum QUERY_ORDER_BY {
        CREATION_DATE_ASC("creationDate", true),
        CREATION_DATE_DESC("creationDate", false),
        ID_ASC("id", true),
        ID_DESC("id", false);

        private final String propertyName;
        private final boolean asc;

        private QUERY_ORDER_BY(String propertyName, boolean asc) {
            this.propertyName = propertyName;
            this.asc = asc;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public boolean isAsc() {
            return this.asc;
        }
    }
}

