/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.utils;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public final class Java6CompatibleThreadLocalRandom {
    static boolean threadLocalRandomPresent = true;
    private static final String THREAD_LOCAL_RANDOM_CLASS_NAME = "java.util.concurrent.ThreadLocalRandom";
    private static final ThreadLocal<Random> threadLocal;

    public static Random current() {
        if (threadLocalRandomPresent) {
            return ThreadLocalRandomAccessor.getCurrentThreadLocalRandom();
        }
        return threadLocal.get();
    }

    private Java6CompatibleThreadLocalRandom() {
    }

    static {
        try {
            Class.forName(THREAD_LOCAL_RANDOM_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            threadLocalRandomPresent = false;
        }
        threadLocal = new ThreadLocal<Random>(){

            @Override
            protected Random initialValue() {
                return new Random();
            }
        };
    }

    private static class ThreadLocalRandomAccessor {
        private ThreadLocalRandomAccessor() {
        }

        @IgnoreJRERequirement
        private static Random getCurrentThreadLocalRandom() {
            return ThreadLocalRandom.current();
        }
    }
}

