/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.rt.transports;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.tests.rt.RtReceiver;
import org.jgroups.tests.rt.RtTransport;
import org.jgroups.util.Util;

public class TcpTransport
implements RtTransport {
    protected ServerSocket srv_sock;
    protected Socket sock;
    protected OutputStream output;
    protected InputStream input;
    protected Receiver receiver_thread;
    protected RtReceiver receiver;
    protected InetAddress host = null;
    protected int port = 7800;
    protected boolean server;
    protected boolean tcp_nodelay;
    protected final Log log = LogFactory.getLog(TcpTransport.class);

    @Override
    public String[] options() {
        return new String[]{"-host <host>", "-port <port>", "-server", "-tcp-nodelay"};
    }

    @Override
    public void options(String ... options) throws Exception {
        if (options == null) {
            return;
        }
        for (int i = 0; i < options.length; ++i) {
            if (options[i].equals("-server")) {
                this.server = true;
                continue;
            }
            if (options[i].equals("-host")) {
                this.host = InetAddress.getByName(options[++i]);
                continue;
            }
            if (options[i].equals("-port")) {
                this.port = Integer.parseInt(options[++i]);
                continue;
            }
            if (!options[i].equals("-tcp-nodelay")) continue;
            this.tcp_nodelay = true;
        }
        if (this.host == null) {
            this.host = InetAddress.getLocalHost();
        }
    }

    @Override
    public void receiver(RtReceiver receiver) {
        this.receiver = receiver;
    }

    @Override
    public Object localAddress() {
        return null;
    }

    @Override
    public List<? extends Object> clusterMembers() {
        return null;
    }

    @Override
    public void start(String ... options) throws Exception {
        this.options(options);
        if (this.server) {
            this.srv_sock = new ServerSocket(this.port, 50, this.host);
            System.out.println("server started (ctrl-c to kill)");
            while (true) {
                Socket client_sock = this.srv_sock.accept();
                client_sock.setTcpNoDelay(this.tcp_nodelay);
                this.input = client_sock.getInputStream();
                this.output = client_sock.getOutputStream();
                this.receiver_thread = new Receiver(this.input);
                this.receiver_thread.start();
            }
        }
        this.sock = new Socket();
        this.sock.setTcpNoDelay(this.tcp_nodelay);
        this.sock.connect(new InetSocketAddress(this.host, this.port));
        this.output = this.sock.getOutputStream();
        this.input = this.sock.getInputStream();
        this.receiver_thread = new Receiver(this.input);
        this.receiver_thread.start();
    }

    @Override
    public void stop() {
        Util.close(this.sock, this.srv_sock, this.input, this.output);
    }

    @Override
    public void send(Object dest, byte[] buf, int offset, int length) throws Exception {
        this.output.write(buf, offset, length);
    }

    protected class Receiver
    extends Thread {
        protected final InputStream in;

        public Receiver(InputStream in) {
            this.in = in;
        }

        @Override
        public void run() {
            byte[] buf = new byte[11];
            while (true) {
                try {
                    while (true) {
                        int num;
                        if ((num = this.in.read(buf, 0, buf.length)) == -1) {
                            return;
                        }
                        if (num != buf.length) {
                            throw new IllegalStateException("expected " + buf.length + " bytes, but got only " + num);
                        }
                        if (TcpTransport.this.receiver == null) continue;
                        TcpTransport.this.receiver.receive(null, buf, 0, buf.length);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

