/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Modifier;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.jboss.DefaultExternalizerProviders;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.marshalling.spi.IntSerializer;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ExternalizerObjectTable
implements ObjectTable {
    private final List<Externalizer<Object>> externalizers;
    private final Map<Class<?>, Integer> indexes = new IdentityHashMap();
    private final IntSerializer indexSerializer;

    public ExternalizerObjectTable(ClassLoader ... loader) {
        this(ExternalizerObjectTable.loadExternalizers(loader));
    }

    private static List<Externalizer<Object>> loadExternalizers(final ClassLoader ... loaders) {
        List loadedExternalizers = (List)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<List<Externalizer<Object>>>(){

            @Override
            public List<Externalizer<Object>> run() {
                LinkedList<Externalizer<Object>> externalizers = new LinkedList<Externalizer<Object>>();
                for (ClassLoader loader : loaders) {
                    for (Externalizer externalizer : ServiceLoader.load(Externalizer.class, loader)) {
                        externalizers.add((Externalizer<Object>)externalizer);
                    }
                }
                return externalizers;
            }
        });
        EnumSet<DefaultExternalizerProviders> providers = EnumSet.allOf(DefaultExternalizerProviders.class);
        int size = loadedExternalizers.size();
        for (DefaultExternalizerProviders provider : providers) {
            size += provider.get().size();
        }
        ArrayList<Externalizer<Object>> result = new ArrayList<Externalizer<Object>>(size);
        for (DefaultExternalizerProviders provider : providers) {
            result.addAll((Collection<Externalizer<Object>>)provider.get());
        }
        result.addAll(loadedExternalizers);
        return result;
    }

    public ExternalizerObjectTable(List<Externalizer<Object>> externalizers) {
        this(IndexSerializer.select((int)externalizers.size()), externalizers);
    }

    @SafeVarargs
    public ExternalizerObjectTable(Externalizer<Object> ... externalizers) {
        this(Arrays.asList(externalizers));
    }

    private ExternalizerObjectTable(IntSerializer indexSerializer, List<Externalizer<Object>> externalizers) {
        this.indexSerializer = indexSerializer;
        this.externalizers = externalizers;
        ListIterator<Externalizer<Object>> iterator = externalizers.listIterator();
        while (iterator.hasNext()) {
            this.indexes.putIfAbsent(iterator.next().getTargetClass(), iterator.previousIndex());
        }
    }

    public ObjectTable.Writer getObjectWriter(Object object) throws IOException {
        Class<Object> targetClass = object.getClass().isEnum() ? ((Enum)object).getDeclaringClass() : object.getClass();
        Class<Object> superClass = targetClass.getSuperclass();
        while (!this.indexes.containsKey(targetClass) && superClass != null && Modifier.isAbstract(superClass.getModifiers())) {
            targetClass = superClass;
            superClass = targetClass.getSuperclass();
        }
        Integer index = this.indexes.get(targetClass);
        return index != null ? new ExternalizerWriter(index, this.indexSerializer, this.externalizers.get(index)) : null;
    }

    public Object readObject(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        int index = this.indexSerializer.readInt((DataInput)unmarshaller);
        if (index >= this.externalizers.size()) {
            throw new IllegalStateException();
        }
        return this.externalizers.get(index).readObject((ObjectInput)unmarshaller);
    }

    private static class ExternalizerWriter
    implements ObjectTable.Writer {
        private final int index;
        private final IntSerializer serializer;
        private final Externalizer<Object> externalizer;

        ExternalizerWriter(int index, IntSerializer serializer, Externalizer<Object> externalizer) {
            this.index = index;
            this.serializer = serializer;
            this.externalizer = externalizer;
        }

        public void writeObject(Marshaller marshaller, Object object) throws IOException {
            this.serializer.writeInt((DataOutput)marshaller, this.index);
            this.externalizer.writeObject((ObjectOutput)marshaller, object);
        }
    }
}

