/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.metadata.api.resourceadapter.WorkManagerSecurity;
import org.jboss.as.connector.metadata.resourceadapter.WorkManagerSecurityImpl;
import org.jboss.as.connector.subsystems.resourceadapters.AS7ResourceAdapterTags;
import org.jboss.as.connector.subsystems.resourceadapters.CommonIronJacamarParser;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.Namespace;
import org.jboss.as.connector.util.ParserException;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.Activations;
import org.jboss.jca.common.api.metadata.resourceadapter.WorkManager;
import org.jboss.jca.common.api.metadata.resourceadapter.WorkManagerSecurity;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.resourceadapter.WorkManagerImpl;
import org.jboss.logging.Messages;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class ResourceAdapterParser
extends CommonIronJacamarParser {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    public void parse(XMLExtendedStreamReader reader, ModelNode subsystemAddOperation, List<ModelNode> list, ModelNode parentAddress) throws Exception {
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Tag.forName(reader.getLocalName())) {
                        case RESOURCE_ADAPTERS: {
                            this.parseResourceAdapters(reader, list, parentAddress);
                            continue block8;
                        }
                        case REPORT_DIRECTORY: {
                            this.parseReportDirectory((XMLStreamReader)reader, subsystemAddOperation);
                            continue block8;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
            throw new IllegalStateException();
        }
    }

    private void parseResourceAdapters(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.RESOURCE_ADAPTERS) {
                        return;
                    }
                    if (Activations.Tag.forName((String)reader.getLocalName()) != Activations.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Activations.Tag.forName((String)reader.getLocalName())) {
                        case RESOURCE_ADAPTER: {
                            this.parseResourceAdapter(reader, list, parentAddress);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseResourceAdapter(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        ModelNode raAddress = parentAddress.clone();
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        String archiveOrModuleName = null;
        HashMap<String, ModelNode> configPropertiesOperations = new HashMap<String, ModelNode>();
        HashMap<String, ModelNode> connectionDefinitionsOperations = new HashMap<String, ModelNode>();
        HashMap<String, HashMap<String, ModelNode>> cfConfigPropertiesOperations = new HashMap<String, HashMap<String, ModelNode>>();
        HashMap<String, ModelNode> adminObjectsOperations = new HashMap<String, ModelNode>();
        HashMap<String, HashMap<String, ModelNode>> aoConfigPropertiesOperations = new HashMap<String, HashMap<String, ModelNode>>();
        boolean archiveOrModuleMatched = false;
        boolean txSupportMatched = false;
        boolean isXa = false;
        String id = null;
        int attributeSize = reader.getAttributeCount();
        block25: for (int i = 0; i < attributeSize; ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case ID: {
                    id = value;
                    continue block25;
                }
                case STATISTICS_ENABLED: {
                    Constants.STATISTICS_ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block25;
                }
            }
        }
        while (reader.hasNext()) {
            block4 : switch (reader.nextTag()) {
                case 2: {
                    if (Activations.Tag.forName((String)reader.getLocalName()) == Activations.Tag.RESOURCE_ADAPTER) {
                        ModelNode configEnv;
                        ModelNode env;
                        if (!archiveOrModuleMatched) {
                            throw new ParserException(bundle.requiredElementMissing(Constants.ARCHIVE.getName(), "resource-adapter"));
                        }
                        if (id != null) {
                            raAddress.add("resource-adapter", id);
                        } else {
                            raAddress.add("resource-adapter", archiveOrModuleName);
                        }
                        raAddress.protect();
                        operation.get("address").set(raAddress);
                        list.add(operation);
                        for (Map.Entry<String, ModelNode> entry : configPropertiesOperations.entrySet()) {
                            env = raAddress.clone();
                            env.add(Constants.CONFIG_PROPERTIES.getName(), entry.getKey());
                            env.protect();
                            entry.getValue().get("address").set(env);
                            list.add(entry.getValue());
                        }
                        for (Map.Entry<String, ModelNode> entry : connectionDefinitionsOperations.entrySet()) {
                            env = raAddress.clone();
                            env.add("connection-definitions", entry.getKey());
                            env.protect();
                            entry.getValue().get("address").set(env);
                            list.add(entry.getValue());
                            HashMap<String, ModelNode> properties = cfConfigPropertiesOperations.get(entry.getKey());
                            if (properties == null) continue;
                            for (Map.Entry<String, ModelNode> configEntry : properties.entrySet()) {
                                configEnv = env.clone();
                                configEnv.add(Constants.CONFIG_PROPERTIES.getName(), configEntry.getKey());
                                configEnv.protect();
                                configEntry.getValue().get("address").set(configEnv);
                                list.add(configEntry.getValue());
                            }
                        }
                        for (Map.Entry<String, ModelNode> entry : adminObjectsOperations.entrySet()) {
                            env = raAddress.clone();
                            env.add("admin-objects", entry.getKey());
                            env.protect();
                            entry.getValue().get("address").set(env);
                            list.add(entry.getValue());
                            HashMap<String, ModelNode> aoProperties = aoConfigPropertiesOperations.get(entry.getKey());
                            if (aoProperties == null) continue;
                            for (Map.Entry<String, ModelNode> configEntry : aoProperties.entrySet()) {
                                configEnv = env.clone();
                                configEnv.add(Constants.CONFIG_PROPERTIES.getName(), configEntry.getKey());
                                configEnv.protect();
                                configEntry.getValue().get("address").set(configEnv);
                                list.add(configEntry.getValue());
                            }
                        }
                        return;
                    }
                    if (AS7ResourceAdapterTags.forName(reader.getLocalName()) != AS7ResourceAdapterTags.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (AS7ResourceAdapterTags.forName(reader.getLocalName())) {
                        case ADMIN_OBJECTS: 
                        case CONNECTION_DEFINITIONS: 
                        case BEAN_VALIDATION_GROUPS: {
                            break block4;
                        }
                        case ADMIN_OBJECT: {
                            this.parseAdminObjects(reader, adminObjectsOperations, aoConfigPropertiesOperations);
                            break block4;
                        }
                        case CONNECTION_DEFINITION: {
                            switch (Namespace.forUri(reader.getNamespaceURI())) {
                                case RESOURCEADAPTERS_1_0: 
                                case RESOURCEADAPTERS_1_1: 
                                case RESOURCEADAPTERS_2_0: {
                                    this.parseConnectionDefinitions_1_0(reader, connectionDefinitionsOperations, cfConfigPropertiesOperations, isXa);
                                    break block4;
                                }
                                case RESOURCEADAPTERS_3_0: {
                                    this.parseConnectionDefinitions_3_0(reader, connectionDefinitionsOperations, cfConfigPropertiesOperations, isXa);
                                    break block4;
                                }
                                case RESOURCEADAPTERS_4_0: {
                                    this.parseConnectionDefinitions_4_0(reader, connectionDefinitionsOperations, cfConfigPropertiesOperations, isXa);
                                    break block4;
                                }
                            }
                            this.parseConnectionDefinitions_5_0(reader, connectionDefinitionsOperations, cfConfigPropertiesOperations, isXa);
                            break block4;
                        }
                        case BEAN_VALIDATION_GROUP: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            operation.get(Constants.BEANVALIDATION_GROUPS.getName()).add(Constants.BEANVALIDATIONGROUP.parse(value, (XMLStreamReader)reader));
                            break block4;
                        }
                        case BOOTSTRAP_CONTEXT: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.BOOTSTRAP_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block4;
                        }
                        case CONFIG_PROPERTY: {
                            this.parseConfigProperties(reader, configPropertiesOperations);
                            break block4;
                        }
                        case TRANSACTION_SUPPORT: {
                            if (txSupportMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.TRANSACTION_SUPPORT.getXmlName()));
                            }
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTION_SUPPORT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            ModelNode transactionSupport = Constants.TRANSACTION_SUPPORT.parse(value, (XMLStreamReader)reader);
                            String transactionSupportResolved = transactionSupport.resolve().asString();
                            isXa = value != null && TransactionSupportEnum.valueOf((String)transactionSupportResolved) == TransactionSupportEnum.XATransaction;
                            txSupportMatched = true;
                            break block4;
                        }
                        case WORKMANAGER: {
                            this.parseWorkManager(operation, (XMLStreamReader)reader);
                            break block4;
                        }
                        case ARCHIVE: {
                            if (archiveOrModuleMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.ARCHIVE.getXmlName()));
                            }
                            archiveOrModuleName = this.rawElementText((XMLStreamReader)reader);
                            Constants.ARCHIVE.parseAndSetParameter(archiveOrModuleName, operation, (XMLStreamReader)reader);
                            archiveOrModuleMatched = true;
                            break block4;
                        }
                        case MODULE: {
                            if (archiveOrModuleMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.MODULE.getXmlName()));
                            }
                            String moduleId = this.rawAttributeText((XMLStreamReader)reader, "id");
                            String moduleSlot = this.rawAttributeText((XMLStreamReader)reader, "slot", "main");
                            archiveOrModuleName = moduleId + ":" + moduleSlot;
                            Constants.MODULE.parseAndSetParameter(archiveOrModuleName, operation, (XMLStreamReader)reader);
                            archiveOrModuleMatched = true;
                            break block4;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected WorkManager parseWorkManager(ModelNode operation, XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        WorkManagerSecurity security = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Activation.Tag.forName((String)reader.getLocalName()) == Activation.Tag.WORKMANAGER) {
                        return new WorkManagerImpl(security);
                    }
                    if (Activation.Tag.forName((String)reader.getLocalName()) != Activation.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (WorkManager.Tag.forName((String)reader.getLocalName())) {
                        case SECURITY: {
                            Constants.WM_SECURITY.parseAndSetParameter("true", operation, reader);
                            switch (Namespace.forUri(reader.getNamespaceURI())) {
                                case RESOURCEADAPTERS_1_0: 
                                case RESOURCEADAPTERS_1_1: 
                                case RESOURCEADAPTERS_2_0: 
                                case RESOURCEADAPTERS_3_0: 
                                case RESOURCEADAPTERS_4_0: {
                                    security = this.parseWorkManagerSecurity(operation, reader);
                                    break block0;
                                }
                            }
                            security = this.parseWorkManagerSecurity_5_0(operation, reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected WorkManagerSecurity parseWorkManagerSecurity(ModelNode operation, XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        boolean mappingRequired = false;
        String domain = null;
        String defaultPrincipal = null;
        List<String> defaultGroups = null;
        Map<String, String> userMappings = null;
        Map<String, String> groupMappings = null;
        boolean userMappingEnabled = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (WorkManager.Tag.forName((String)reader.getLocalName()) == WorkManager.Tag.SECURITY) {
                        return new WorkManagerSecurityImpl(mappingRequired, domain, false, defaultPrincipal, defaultGroups, userMappings, groupMappings);
                    }
                    if (WorkManagerSecurity.Tag.forName(reader.getLocalName()) != WorkManagerSecurity.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (WorkManagerSecurity.Tag.forName(reader.getLocalName())) {
                        case DEFAULT_GROUPS: 
                        case MAPPINGS: {
                            break block0;
                        }
                        case MAPPING_REQUIRED: {
                            String value = this.rawElementText(reader);
                            Constants.WM_SECURITY_MAPPING_REQUIRED.parseAndSetParameter(value, operation, reader);
                            break block0;
                        }
                        case DOMAIN: {
                            String value = domain = this.rawElementText(reader);
                            Constants.WM_SECURITY_DOMAIN.parseAndSetParameter(value, operation, reader);
                            break block0;
                        }
                        case DEFAULT_PRINCIPAL: {
                            String value = this.rawElementText(reader);
                            Constants.WM_SECURITY_DEFAULT_PRINCIPAL.parseAndSetParameter(value, operation, reader);
                            break block0;
                        }
                        case GROUP: {
                            String value = this.rawElementText(reader);
                            operation.get(Constants.WM_SECURITY_DEFAULT_GROUPS.getName()).add(Constants.WM_SECURITY_DEFAULT_GROUP.parse(value, reader));
                            break block0;
                        }
                        case USERS: {
                            userMappingEnabled = true;
                            break block0;
                        }
                        case GROUPS: {
                            userMappingEnabled = false;
                            break block0;
                        }
                        case MAP: {
                            ModelNode object;
                            String to;
                            String from;
                            if (userMappingEnabled) {
                                from = this.rawAttributeText(reader, WorkManagerSecurity.Attribute.FROM.getLocalName());
                                if (from == null || from.trim().equals("")) {
                                    throw new ParserException(bundle.requiredAttributeMissing(WorkManagerSecurity.Attribute.FROM.getLocalName(), reader.getLocalName()));
                                }
                                to = this.rawAttributeText(reader, WorkManagerSecurity.Attribute.TO.getLocalName());
                                if (to == null || to.trim().equals("")) {
                                    throw new ParserException(bundle.requiredAttributeMissing(WorkManagerSecurity.Attribute.TO.getLocalName(), reader.getLocalName()));
                                }
                                object = new ModelNode();
                                Constants.WM_SECURITY_MAPPING_FROM.parseAndSetParameter(from, object, reader);
                                Constants.WM_SECURITY_MAPPING_TO.parseAndSetParameter(to, object, reader);
                                operation.get(Constants.WM_SECURITY_MAPPING_USERS.getName()).add(object);
                                break block0;
                            }
                            from = this.rawAttributeText(reader, WorkManagerSecurity.Attribute.FROM.getLocalName());
                            if (from == null || from.trim().equals("")) {
                                throw new ParserException(bundle.requiredAttributeMissing(WorkManagerSecurity.Attribute.FROM.getLocalName(), reader.getLocalName()));
                            }
                            to = this.rawAttributeText(reader, WorkManagerSecurity.Attribute.TO.getLocalName());
                            if (to == null || to.trim().equals("")) {
                                throw new ParserException(bundle.requiredAttributeMissing(WorkManagerSecurity.Attribute.TO.getLocalName(), reader.getLocalName()));
                            }
                            object = new ModelNode();
                            Constants.WM_SECURITY_MAPPING_FROM.parseAndSetParameter(from, object, reader);
                            Constants.WM_SECURITY_MAPPING_TO.parseAndSetParameter(to, object, reader);
                            operation.get(Constants.WM_SECURITY_MAPPING_GROUPS.getName()).add(object);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected WorkManagerSecurity parseWorkManagerSecurity_5_0(ModelNode operation, XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        boolean mappingRequired = false;
        String domain = null;
        boolean elytronEnabled = false;
        String defaultPrincipal = null;
        List<String> defaultGroups = null;
        Map<String, String> userMappings = null;
        Map<String, String> groupMappings = null;
        boolean userMappingEnabled = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (WorkManager.Tag.forName((String)reader.getLocalName()) == WorkManager.Tag.SECURITY) {
                        return new WorkManagerSecurityImpl(mappingRequired, domain, elytronEnabled, defaultPrincipal, defaultGroups, userMappings, groupMappings);
                    }
                    if (WorkManagerSecurity.Tag.forName(reader.getLocalName()) != WorkManagerSecurity.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (WorkManagerSecurity.Tag.forName(reader.getLocalName())) {
                        case DEFAULT_GROUPS: 
                        case MAPPINGS: {
                            break block0;
                        }
                        case MAPPING_REQUIRED: {
                            String value = this.rawElementText(reader);
                            Constants.WM_SECURITY_MAPPING_REQUIRED.parseAndSetParameter(value, operation, reader);
                            break block0;
                        }
                        case DOMAIN: {
                            String value = domain = this.rawElementText(reader);
                            Constants.WM_SECURITY_DOMAIN.parseAndSetParameter(value, operation, reader);
                            break block0;
                        }
                        case ELYTRON_SECURITY_DOMAIN: {
                            elytronEnabled = true;
                            String value = domain = this.rawElementText(reader);
                            Constants.WM_ELYTRON_SECURITY_DOMAIN.parseAndSetParameter(value, operation, reader);
                            break block0;
                        }
                        case DEFAULT_PRINCIPAL: {
                            String value = this.rawElementText(reader);
                            Constants.WM_SECURITY_DEFAULT_PRINCIPAL.parseAndSetParameter(value, operation, reader);
                            break block0;
                        }
                        case GROUP: {
                            String value = this.rawElementText(reader);
                            operation.get(Constants.WM_SECURITY_DEFAULT_GROUPS.getName()).add(Constants.WM_SECURITY_DEFAULT_GROUP.parse(value, reader));
                            break block0;
                        }
                        case USERS: {
                            userMappingEnabled = true;
                            break block0;
                        }
                        case GROUPS: {
                            userMappingEnabled = false;
                            break block0;
                        }
                        case MAP: {
                            ModelNode object;
                            String to;
                            String from;
                            if (userMappingEnabled) {
                                from = this.rawAttributeText(reader, WorkManagerSecurity.Attribute.FROM.getLocalName());
                                if (from == null || from.trim().equals("")) {
                                    throw new ParserException(bundle.requiredAttributeMissing(WorkManagerSecurity.Attribute.FROM.getLocalName(), reader.getLocalName()));
                                }
                                to = this.rawAttributeText(reader, WorkManagerSecurity.Attribute.TO.getLocalName());
                                if (to == null || to.trim().equals("")) {
                                    throw new ParserException(bundle.requiredAttributeMissing(WorkManagerSecurity.Attribute.TO.getLocalName(), reader.getLocalName()));
                                }
                                object = new ModelNode();
                                Constants.WM_SECURITY_MAPPING_FROM.parseAndSetParameter(from, object, reader);
                                Constants.WM_SECURITY_MAPPING_TO.parseAndSetParameter(to, object, reader);
                                operation.get(Constants.WM_SECURITY_MAPPING_USERS.getName()).add(object);
                                break block0;
                            }
                            from = this.rawAttributeText(reader, WorkManagerSecurity.Attribute.FROM.getLocalName());
                            if (from == null || from.trim().equals("")) {
                                throw new ParserException(bundle.requiredAttributeMissing(WorkManagerSecurity.Attribute.FROM.getLocalName(), reader.getLocalName()));
                            }
                            to = this.rawAttributeText(reader, WorkManagerSecurity.Attribute.TO.getLocalName());
                            if (to == null || to.trim().equals("")) {
                                throw new ParserException(bundle.requiredAttributeMissing(WorkManagerSecurity.Attribute.TO.getLocalName(), reader.getLocalName()));
                            }
                            object = new ModelNode();
                            Constants.WM_SECURITY_MAPPING_FROM.parseAndSetParameter(from, object, reader);
                            Constants.WM_SECURITY_MAPPING_TO.parseAndSetParameter(to, object, reader);
                            operation.get(Constants.WM_SECURITY_MAPPING_GROUPS.getName()).add(object);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected void parseReportDirectory(XMLStreamReader reader, ModelNode subsystemAddOperation) throws XMLStreamException, ParserException, ValidateException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case PATH: {
                    Constants.REPORT_DIRECTORY.parseAndSetParameter(value, subsystemAddOperation, reader);
                    continue block6;
                }
                default: {
                    throw new ParserException(bundle.unexpectedAttribute(attribute.getLocalName(), reader.getLocalName()));
                }
            }
        }
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.REPORT_DIRECTORY) {
                        return;
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
            }
            throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
        }
    }

    public static enum Attribute {
        UNKNOWN(null),
        ID("id"),
        STATISTICS_ENABLED("statistics-enabled"),
        PATH("path");

        private String name;
        private static final Map<String, Attribute> MAP;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        Attribute value(String v) {
            this.name = v;
            return this;
        }

        public static Attribute forName(String localName) {
            Attribute element = MAP.get(localName);
            return element == null ? UNKNOWN.value(localName) : element;
        }

        static {
            HashMap<String, Attribute> map = new HashMap<String, Attribute>();
            for (Attribute element : Attribute.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    public static enum Tag {
        UNKNOWN(null),
        RESOURCE_ADAPTERS("resource-adapters"),
        REPORT_DIRECTORY("report-directory");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

