/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.JmxAuthorizer;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.extension.ExtensionContextSupplement;
import org.jboss.as.controller.extension.RuntimeHostControllerInfoAccessor;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.jmx.ExposeModelResource;
import org.jboss.as.jmx.ExposeModelResourceExpression;
import org.jboss.as.jmx.ExposeModelResourceResolved;
import org.jboss.as.jmx.JMXSubsystemRootResource;
import org.jboss.as.jmx.JmxAuditLogHandlerReferenceResourceDefinition;
import org.jboss.as.jmx.JmxAuditLoggerResourceDefinition;
import org.jboss.as.jmx.Namespace;
import org.jboss.as.jmx.RemotingConnectorResource;
import org.jboss.as.jmx.logging.JmxLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JMXExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jmx";
    private static final String RESOURCE_NAME = JMXExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final SensitivityClassification JMX_SENSITIVITY = new SensitivityClassification("jmx", "jmx", false, false, true);
    static final SensitiveTargetAccessConstraintDefinition JMX_SENSITIVITY_DEF = new SensitiveTargetAccessConstraintDefinition(JMX_SENSITIVITY);
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    private static final ModelVersion CURRENT_VERSION = ModelVersion.create((int)1, (int)2, (int)0);

    static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, JMXExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_VERSION);
        registration.setHostCapable();
        ManagedAuditLogger auditLogger = (ManagedAuditLogger)((ExtensionContextSupplement)context).getAuditLogger(false, true);
        JmxAuthorizer authorizer = ((ExtensionContextSupplement)context).getAuthorizer();
        Supplier securityIdentitySupplier = ((ExtensionContextSupplement)context).getSecurityIdentitySupplier();
        RuntimeHostControllerInfoAccessor hostInfoAccessor = ((ExtensionContextSupplement)context).getHostControllerInfoAccessor();
        registration.registerSubsystemModel((ResourceDefinition)JMXSubsystemRootResource.create(auditLogger, authorizer, securityIdentitySupplier, hostInfoAccessor));
        registration.registerXMLElementWriter(() -> new JMXSubsystemWriter());
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JMX_1_0.getUriString(), () -> new JMXSubsystemParser_1_0());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JMX_1_1.getUriString(), () -> new JMXSubsystemParser_1_1());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JMX_1_2.getUriString(), () -> new JMXSubsystemParser_1_2());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JMX_1_3.getUriString(), () -> new JMXSubsystemParser_1_3());
    }

    private static ModelNode createAddOperation() {
        return JMXExtension.createOperation("add", new String[0]);
    }

    private static ModelNode createOperation(String name, String ... addressElements) {
        ModelNode op = new ModelNode();
        op.get("operation").set(name);
        op.get("address").add("subsystem", SUBSYSTEM_NAME);
        for (int i = 0; i < addressElements.length; ++i) {
            op.get("address").add(addressElements[i], addressElements[++i]);
        }
        return op;
    }

    private static class JMXSubsystemWriter
    implements XMLStreamConstants,
    XMLElementWriter<SubsystemMarshallingContext> {
        private JMXSubsystemWriter() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            Namespace schemaVer = Namespace.CURRENT;
            ModelNode node = context.getModelNode();
            context.startSubsystemElement(schemaVer.getUriString(), false);
            if (node.hasDefined("expose-model")) {
                ModelNode showModel = node.get("expose-model");
                if (showModel.hasDefined("resolved")) {
                    writer.writeEmptyElement("expose-resolved-model");
                    ExposeModelResourceResolved.DOMAIN_NAME.marshallAsAttribute(showModel.get("resolved"), false, (XMLStreamWriter)writer);
                    ExposeModelResourceResolved.PROPER_PROPERTY_FORMAT.marshallAsAttribute(showModel.get("resolved"), false, (XMLStreamWriter)writer);
                }
                if (showModel.hasDefined("expression")) {
                    writer.writeEmptyElement("expose-expression-model");
                    ExposeModelResourceExpression.DOMAIN_NAME.marshallAsAttribute(showModel.get("expression"), false, (XMLStreamWriter)writer);
                }
            }
            if (node.hasDefined("remoting-connector")) {
                writer.writeStartElement("remoting-connector");
                ModelNode resourceModel = node.get("remoting-connector").get(JMXExtension.SUBSYSTEM_NAME);
                RemotingConnectorResource.USE_MANAGEMENT_ENDPOINT.marshallAsAttribute(resourceModel, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            if (node.hasDefined(JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getKey()) && node.get(JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getKey()).hasDefined(JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getValue())) {
                ModelNode auditLog = node.get(new String[]{JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getKey(), JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getValue()});
                writer.writeStartElement("audit-log");
                JmxAuditLoggerResourceDefinition.LOG_BOOT.marshallAsAttribute(auditLog, (XMLStreamWriter)writer);
                JmxAuditLoggerResourceDefinition.LOG_READ_ONLY.marshallAsAttribute(auditLog, (XMLStreamWriter)writer);
                JmxAuditLoggerResourceDefinition.ENABLED.marshallAsAttribute(auditLog, (XMLStreamWriter)writer);
                if (auditLog.hasDefined("handler") && !auditLog.get("handler").keys().isEmpty()) {
                    writer.writeStartElement("handlers");
                    for (String key : auditLog.get("handler").keys()) {
                        writer.writeEmptyElement("handler");
                        writer.writeAttribute("name", key);
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (node.hasDefined(JMXSubsystemRootResource.NON_CORE_MBEAN_SENSITIVITY.getName())) {
                writer.writeStartElement("sensitivity");
                JMXSubsystemRootResource.NON_CORE_MBEAN_SENSITIVITY.marshallAsAttribute(node, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private static class JMXSubsystemParser_1_3
    extends JMXSubsystemParser_1_2 {
        private JMXSubsystemParser_1_3() {
        }

        @Override
        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            boolean showResolvedModel = false;
            boolean showExpressionModel = false;
            boolean connectorAdd = false;
            boolean auditLog = false;
            boolean sensitivity = false;
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            ModelNode add = JMXExtension.createAddOperation();
            list.add(add);
            block14: while (reader.hasNext() && reader.nextTag() != 2) {
                String element;
                switch (element = reader.getLocalName()) {
                    case "expose-resolved-model": {
                        if (showResolvedModel) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)"expose-resolved-model");
                        }
                        showResolvedModel = true;
                        list.add(this.parseShowModelElement(reader, "resolved"));
                        continue block14;
                    }
                    case "expose-expression-model": {
                        if (showExpressionModel) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)"expose-expression-model");
                        }
                        showExpressionModel = true;
                        list.add(this.parseShowModelElement(reader, "expression"));
                        continue block14;
                    }
                    case "remoting-connector": {
                        if (connectorAdd) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)"remoting-connector");
                        }
                        connectorAdd = true;
                        list.add(this.parseRemoteConnector(reader));
                        continue block14;
                    }
                    case "audit-log": {
                        if (auditLog) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)"audit-log");
                        }
                        auditLog = true;
                        this.parseAuditLogElement(reader, list);
                        continue block14;
                    }
                    case "sensitivity": {
                        if (sensitivity) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)"sensitivity");
                        }
                        sensitivity = true;
                        this.parseSensitivity(add, reader);
                        continue block14;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        private void parseSensitivity(ModelNode add, XMLExtendedStreamReader reader) throws XMLStreamException {
            int count = reader.getAttributeCount();
            block6: for (int i = 0; i < count; ++i) {
                String attribute;
                String value = reader.getAttributeValue(i);
                switch (attribute = reader.getAttributeLocalName(i)) {
                    case "non-core-mbeans": {
                        JMXSubsystemRootResource.NON_CORE_MBEAN_SENSITIVITY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }

        private void parseAuditLogElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode op = JMXExtension.createOperation("add", new String[]{JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getKey(), JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getValue()});
            int count = reader.getAttributeCount();
            block16: for (int i = 0; i < count; ++i) {
                String attribute;
                String value = reader.getAttributeValue(i);
                switch (attribute = reader.getAttributeLocalName(i)) {
                    case "log-boot": {
                        JmxAuditLoggerResourceDefinition.LOG_BOOT.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                        continue block16;
                    }
                    case "log-read-only": {
                        JmxAuditLoggerResourceDefinition.LOG_READ_ONLY.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                        continue block16;
                    }
                    case "enabled": {
                        JmxAuditLoggerResourceDefinition.ENABLED.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                        continue block16;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            list.add(op);
            block17: while (reader.hasNext() && reader.nextTag() != 2) {
                String element;
                switch (element = reader.getLocalName()) {
                    case "handlers": {
                        this.parseAuditLogHandlers(reader, list);
                        continue block17;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        private void parseAuditLogHandlers(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            block6: while (reader.hasNext() && reader.nextTag() != 2) {
                String element;
                switch (element = reader.getLocalName()) {
                    case "handler": {
                        this.parseAuditLogHandler(reader, list);
                        continue block6;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        private void parseAuditLogHandler(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            String name = null;
            int count = reader.getAttributeCount();
            block6: for (int i = 0; i < count; ++i) {
                String attribute;
                String value = reader.getAttributeValue(i);
                switch (attribute = reader.getAttributeLocalName(i)) {
                    case "name": {
                        name = value;
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
            }
            ModelNode op = JMXExtension.createOperation("add", new String[]{JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getKey(), JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getValue(), JmxAuditLogHandlerReferenceResourceDefinition.PATH_ELEMENT.getKey(), name});
            list.add(op);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private static class JMXSubsystemParser_1_2
    extends JMXSubsystemParser_1_1 {
        private JMXSubsystemParser_1_2() {
        }

        @Override
        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            boolean showResolvedModel = false;
            boolean showExpressionModel = false;
            boolean connectorAdd = false;
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            list.add(JMXExtension.createAddOperation());
            block10: while (reader.hasNext() && reader.nextTag() != 2) {
                String element;
                switch (element = reader.getLocalName()) {
                    case "expose-resolved-model": {
                        if (showResolvedModel) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)"expose-resolved-model");
                        }
                        showResolvedModel = true;
                        list.add(this.parseShowModelElement(reader, "resolved"));
                        continue block10;
                    }
                    case "expose-expression-model": {
                        if (showExpressionModel) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)"expose-expression-model");
                        }
                        showExpressionModel = true;
                        list.add(this.parseShowModelElement(reader, "expression"));
                        continue block10;
                    }
                    case "remoting-connector": {
                        if (connectorAdd) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)"remoting-connector");
                        }
                        connectorAdd = true;
                        list.add(this.parseRemoteConnector(reader));
                        continue block10;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        protected ModelNode parseShowModelElement(XMLExtendedStreamReader reader, String showModelChild) throws XMLStreamException {
            ModelNode op = JMXExtension.createOperation("add", new String[]{"expose-model", showModelChild});
            Object domainName = null;
            Object properPropertyFormat = null;
            block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attribute;
                String value = reader.getAttributeValue(i);
                switch (attribute = reader.getAttributeLocalName(i)) {
                    case "domain-name": {
                        ExposeModelResource.getDomainNameAttribute(showModelChild).parseAndSetParameter(value, op, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case "proper-property-format": {
                        if (showModelChild.equals("resolved")) {
                            ExposeModelResourceResolved.PROPER_PROPERTY_FORMAT.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                            continue block8;
                        }
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (domainName == null && properPropertyFormat == null) {
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            }
            return op;
        }
    }

    private static class JMXSubsystemParser_1_1
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>> {
        private JMXSubsystemParser_1_1() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            boolean showModel = false;
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            Object connectorAdd = null;
            list.add(JMXExtension.createAddOperation());
            block8: while (reader.hasNext() && reader.nextTag() != 2) {
                String element;
                switch (element = reader.getLocalName()) {
                    case "show-model": {
                        if (showModel) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)"show-model");
                        }
                        if (this.parseShowModelElement(reader)) {
                            ModelNode op = JMXExtension.createOperation("add", new String[]{"expose-model", "resolved"});
                            op.get("proper-property-format").set(false);
                            list.add(op);
                        }
                        showModel = true;
                        continue block8;
                    }
                    case "remoting-connector": {
                        if (connectorAdd != null) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)"remoting-connector");
                        }
                        list.add(this.parseRemoteConnector(reader));
                        continue block8;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        protected ModelNode parseRemoteConnector(XMLExtendedStreamReader reader) throws XMLStreamException {
            ModelNode connector = new ModelNode();
            connector.get("operation").set("add");
            connector.get("address").add("subsystem", JMXExtension.SUBSYSTEM_NAME).add("remoting-connector", JMXExtension.SUBSYSTEM_NAME);
            int count = reader.getAttributeCount();
            block6: for (int i = 0; i < count; ++i) {
                String attribute;
                String value = reader.getAttributeValue(i);
                switch (attribute = reader.getAttributeLocalName(i)) {
                    case "use-management-endpoint": {
                        RemotingConnectorResource.USE_MANAGEMENT_ENDPOINT.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return connector;
        }

        private boolean parseShowModelElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"value");
            return ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value");
        }
    }

    private static class JMXSubsystemParser_1_0
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>> {
        private JMXSubsystemParser_1_0() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            list.add(JMXExtension.createAddOperation());
            boolean gotConnector = false;
            block6: while (reader.hasNext() && reader.nextTag() != 2) {
                String element;
                switch (element = reader.getLocalName()) {
                    case "jmx-connector": {
                        if (gotConnector) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)"jmx-connector");
                        }
                        this.parseConnector(reader);
                        gotConnector = true;
                        continue block6;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        void parseConnector(XMLExtendedStreamReader reader) throws XMLStreamException {
            JmxLogger.ROOT_LOGGER.jmxConnectorNotSupported();
            String serverBinding = null;
            String registryBinding = null;
            int count = reader.getAttributeCount();
            block8: for (int i = 0; i < count; ++i) {
                String attribute;
                String value = reader.getAttributeValue(i);
                switch (attribute = reader.getAttributeLocalName(i)) {
                    case "server-binding": {
                        serverBinding = value;
                        continue block8;
                    }
                    case "registry-binding": {
                        registryBinding = value;
                        continue block8;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            if (serverBinding == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("server-binding"));
            }
            if (registryBinding == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("registry-binding"));
            }
        }
    }
}

