/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.autoconfig;

import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Fallback;

public interface Config {
    public void validate();

    public Class<?> beanClass();

    public MethodDescriptor method();

    public Class<? extends Annotation> annotationType();

    public boolean isOnMethod();

    public static <A extends Annotation> boolean isEnabled(Class<A> annotationType, MethodDescriptor method) {
        org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
        Optional onMethod = config.getOptionalValue(method.declaringClass.getName() + "/" + method.name + "/" + annotationType.getSimpleName() + "/enabled", String.class);
        if (onMethod.isPresent()) {
            return Boolean.parseBoolean((String)onMethod.get());
        }
        Optional onClass = config.getOptionalValue(method.declaringClass.getName() + "/" + annotationType.getSimpleName() + "/enabled", String.class);
        if (onClass.isPresent()) {
            return Boolean.parseBoolean((String)onClass.get());
        }
        Optional onGlobal = config.getOptionalValue(annotationType.getSimpleName() + "/enabled", String.class);
        if (onGlobal.isPresent()) {
            return Boolean.parseBoolean((String)onGlobal.get());
        }
        if (Fallback.class.equals(annotationType)) {
            return true;
        }
        return config.getOptionalValue("MP_Fault_Tolerance_NonFallback_Enabled", Boolean.class).orElse(true);
    }
}

