/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Map;
import java.util.TreeMap;

public enum ConsumerField {
    ID("id"),
    SESSION("session"),
    QUEUE("queue"),
    FILTER("filter"),
    ADDRESS("address"),
    USER("user"),
    PROTOCOL("protocol"),
    CLIENT_ID("clientID"),
    LOCAL_ADDRESS("localAddress"),
    REMOTE_ADDRESS("remoteAddress"),
    QUEUE_TYPE("queueType"),
    CREATION_TIME("creationTime");

    private static final Map<String, ConsumerField> lookup;
    private final String name;

    public String getName() {
        return this.name;
    }

    private ConsumerField(String name) {
        this.name = name;
    }

    public static ConsumerField valueOfName(String name) {
        return lookup.get(name);
    }

    static {
        lookup = new TreeMap<String, ConsumerField>(String.CASE_INSENSITIVE_ORDER);
        for (ConsumerField e : ConsumerField.values()) {
            lookup.put(e.name, e);
        }
    }
}

